/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.logging.LogHelper;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.PoolTcpEndpoint;
import org.apache.tomcat.service.TcpConnectionHandler;

public final class PoolTcpConnector
implements ServerConnector {
    public static final String VHOST_PORT = "vhost_port";
    public static final String VHOST_NAME = "vhost_name";
    public static final String VHOST_ADDRESS = "vhost_address";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String INET = "inet";
    public static final String PORT = "port";
    public static final String HANDLER = "handler";
    public static final String THREAD_POOL = "thread_pool";
    public static final String MAX_THREADS = "max_threads";
    public static final String MAX_SPARE_THREADS = "max_spare_threads";
    public static final String MIN_SPARE_THREADS = "min_spare_threads";
    public static final String BACKLOG = "backlog";
    String handlerClassName;
    PoolTcpEndpoint ep;
    TcpConnectionHandler con;
    Hashtable attributes = new Hashtable();
    Object cm;
    private LogHelper loghelper = new LogHelper("tc_log", "PoolTcpConnector");
    private String vhost;
    private InetAddress address;
    private int port;
    private int backlog = -1;
    private boolean usePools = true;
    private int maxThreads = -1;
    private int maxSpareThreads = -1;
    private int minSpareThreads = -1;
    private ServerSocketFactory socketFactory;
    private ServerSocket serverSocket;
    boolean running = true;
    int debug = 0;

    public PoolTcpConnector() {
        this.ep = new PoolTcpEndpoint();
    }

    public void start() throws Exception {
        Object v;
        String key;
        if (this.con == null) {
            throw new Exception("Invalid ConnectionHandler");
        }
        this.con.setServer(this.cm);
        this.con.setAttribute("context.manager", this.cm);
        Enumeration attE = this.attributes.keys();
        while (attE.hasMoreElements()) {
            key = (String)attE.nextElement();
            v = this.attributes.get(key);
            this.con.setAttribute(key, v);
        }
        this.ep.setPort(this.port);
        this.ep.setAddress(this.address);
        this.ep.setPoolOn(this.usePools);
        if (this.backlog > 0) {
            this.ep.setBacklog(this.backlog);
        }
        if (this.maxThreads > 0) {
            this.ep.setMaxThreads(this.maxThreads);
        }
        if (this.maxSpareThreads > 0) {
            this.ep.setMaxSpareThreads(this.maxSpareThreads);
        }
        if (this.minSpareThreads > 0) {
            this.ep.setMinSpareThreads(this.minSpareThreads);
        }
        if (this.socketFactory != null) {
            this.ep.setServerSocketFactory(this.socketFactory);
            attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                key = (String)attE.nextElement();
                v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        this.ep.setConnectionHandler(this.con);
        this.ep.startEndpoint();
        String classN = this.con.getClass().getName();
        int lidot = classN.lastIndexOf(".");
        if (lidot > 0) {
            classN = classN.substring(lidot + 1);
        }
        this.loghelper.log("Starting " + classN + " on " + this.port);
    }

    public void stop() throws Exception {
        this.ep.stopEndpoint();
    }

    public void setTcpConnectionHandler(TcpConnectionHandler handler) {
        this.con = handler;
    }

    public TcpConnectionHandler getTcpConnectionHandler() {
        return this.con;
    }

    public void setServer(Object ctx) {
        this.cm = ctx;
    }

    public void setDebug(int i) {
        this.debug = i;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPort(String portS) {
        this.port = PoolTcpConnector.string2Int(portS);
    }

    public int getPort() {
        return this.port;
    }

    public void setAttribute(String prop, Object value) {
        if (this.debug > 0) {
            this.loghelper.log("setAttribute( " + prop + " , " + value + ")");
        }
        try {
            if (value instanceof String) {
                String valueS = (String)value;
                if (PORT.equals(prop)) {
                    this.setPort(valueS);
                } else if (HANDLER.equals(prop)) {
                    this.con = PoolTcpConnector.string2ConnectionHandler(valueS);
                } else if (THREAD_POOL.equals(prop)) {
                    this.usePools = !valueS.equalsIgnoreCase("off");
                } else if (INET.equals(prop)) {
                    this.address = PoolTcpConnector.string2Inet(valueS);
                } else if (MAX_THREADS.equals(prop)) {
                    this.maxThreads = PoolTcpConnector.string2Int(valueS);
                } else if (MAX_SPARE_THREADS.equals(prop)) {
                    this.maxSpareThreads = PoolTcpConnector.string2Int(valueS);
                } else if (MIN_SPARE_THREADS.equals(prop)) {
                    this.minSpareThreads = PoolTcpConnector.string2Int(valueS);
                } else if (VHOST_NAME.equals(prop)) {
                    this.vhost = valueS;
                } else if (BACKLOG.equals(prop)) {
                    this.backlog = PoolTcpConnector.string2Int(valueS);
                } else if (VHOST_PORT.equals(prop)) {
                    this.port = PoolTcpConnector.string2Int(valueS);
                } else if (SOCKET_FACTORY.equals(prop)) {
                    this.socketFactory = PoolTcpConnector.string2SocketFactory(valueS);
                } else if (VHOST_ADDRESS.equals(prop)) {
                    this.address = PoolTcpConnector.string2Inet(valueS);
                } else if (valueS != null) {
                    this.attributes.put(prop, valueS);
                }
            } else if (VHOST_PORT.equals(prop)) {
                this.port = (Integer)value;
            } else if (VHOST_ADDRESS.equals(prop)) {
                this.address = (InetAddress)value;
            } else if (SOCKET_FACTORY.equals(prop)) {
                this.socketFactory = (ServerSocketFactory)value;
            } else if (value != null) {
                this.attributes.put(prop, value);
            }
        }
        catch (Exception e) {
            this.loghelper.log("setAttribute: " + prop + "=" + value, e, 1);
        }
    }

    public void setProperty(String prop, String value) {
        this.setAttribute(prop, value);
    }

    public Object getAttribute(String prop) {
        if (this.debug > 0) {
            this.loghelper.log("getAttribute( " + prop + ")");
        }
        try {
            if (PORT.equals(prop)) {
                return new Integer(this.port);
            }
            if (HANDLER.equals(prop)) {
                return this.con;
            }
            if (THREAD_POOL.equals(prop)) {
                return new Boolean(this.usePools);
            }
            if (INET.equals(prop)) {
                return this.address;
            }
            if (MAX_THREADS.equals(prop)) {
                return new Integer(this.maxThreads);
            }
            if (MAX_SPARE_THREADS.equals(prop)) {
                return new Integer(this.maxSpareThreads);
            }
            if (MIN_SPARE_THREADS.equals(prop)) {
                return new Integer(this.minSpareThreads);
            }
            if (VHOST_NAME.equals(prop)) {
                return this.vhost;
            }
            if (BACKLOG.equals(prop)) {
                return new Integer(this.backlog);
            }
            if (VHOST_PORT.equals(prop)) {
                return new Integer(this.port);
            }
            if (SOCKET_FACTORY.equals(prop)) {
                return this.socketFactory;
            }
            if (VHOST_ADDRESS.equals(prop)) {
                return this.address;
            }
            return this.attributes.get(prop);
        }
        catch (Exception e) {
            this.loghelper.log("getAttribute: " + prop, e, 1);
            return null;
        }
    }

    public void setLogger(Logger logger) {
        this.loghelper.setLogger(logger);
    }

    public void setSocketFactory(ServerSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    private static TcpConnectionHandler string2ConnectionHandler(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (TcpConnectionHandler)chC.newInstance();
    }

    private static ServerSocketFactory string2SocketFactory(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (ServerSocketFactory)chC.newInstance();
    }

    private static InetAddress string2Inet(String val) throws UnknownHostException {
        return InetAddress.getByName(val);
    }

    private static int string2Int(String val) {
        return Integer.parseInt(val);
    }
}

