/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.opus.Opus;

public class OpusCustom {
    protected OpusCustom() {
        throw new UnsupportedOperationException();
    }

    public static long nopus_custom_mode_create(int Fs, int frame_size, long error) {
        long __functionAddress = Functions.custom_mode_create;
        return JNI.invokePP((int)Fs, (int)frame_size, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusCustomMode *")
    public static long opus_custom_mode_create(@NativeType(value="opus_int32") int Fs, int frame_size, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return OpusCustom.nopus_custom_mode_create(Fs, frame_size, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static void opus_custom_mode_destroy(@NativeType(value="OpusCustomMode *") long mode) {
        long __functionAddress = Functions.custom_mode_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)mode);
        }
        JNI.invokePV((long)mode, (long)__functionAddress);
    }

    public static int opus_custom_encoder_get_size(@NativeType(value="OpusCustomMode const *") long mode, int channels) {
        long __functionAddress = Functions.custom_encoder_get_size;
        if (Checks.CHECKS) {
            Checks.check((long)mode);
        }
        return JNI.invokePI((long)mode, (int)channels, (long)__functionAddress);
    }

    public static int opus_custom_encoder_init(@NativeType(value="OpusCustomEncoder *") long st, @NativeType(value="OpusCustomMode const *") long mode, int channels) {
        long __functionAddress = Functions.custom_encoder_init;
        if (Checks.CHECKS) {
            Checks.check((long)st);
            Checks.check((long)mode);
        }
        return JNI.invokePPI((long)st, (long)mode, (int)channels, (long)__functionAddress);
    }

    public static long nopus_custom_encoder_create(long mode, int channels, long error) {
        long __functionAddress = Functions.custom_encoder_create;
        if (Checks.CHECKS) {
            Checks.check((long)mode);
        }
        return JNI.invokePPP((long)mode, (int)channels, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusCustomEncoder *")
    public static long opus_custom_encoder_create(@NativeType(value="OpusCustomMode const *") long mode, int channels, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return OpusCustom.nopus_custom_encoder_create(mode, channels, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static void opus_custom_encoder_destroy(@NativeType(value="OpusCustomEncoder *") long st) {
        long __functionAddress = Functions.custom_encoder_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        JNI.invokePV((long)st, (long)__functionAddress);
    }

    public static int nopus_custom_encode_float(long st, long pcm, int frame_size, long compressed, int maxCompressedBytes) {
        long __functionAddress = Functions.custom_encode_float;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)pcm, (int)frame_size, (long)compressed, (int)maxCompressedBytes, (long)__functionAddress);
    }

    public static int opus_custom_encode_float(@NativeType(value="OpusCustomEncoder *") long st, @NativeType(value="float const *") FloatBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer compressed) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + (long)Pointer.POINTER_SIZE))));
        }
        return OpusCustom.nopus_custom_encode_float(st, MemoryUtil.memAddress((FloatBuffer)pcm), frame_size, MemoryUtil.memAddress((ByteBuffer)compressed), compressed.remaining());
    }

    public static int nopus_custom_encode(long st, long pcm, int frame_size, long compressed, int maxCompressedBytes) {
        long __functionAddress = Functions.custom_encode;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)pcm, (int)frame_size, (long)compressed, (int)maxCompressedBytes, (long)__functionAddress);
    }

    public static int opus_custom_encode(@NativeType(value="OpusCustomEncoder *") long st, @NativeType(value="opus_int16 const *") ShortBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer compressed) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + (long)Pointer.POINTER_SIZE))));
        }
        return OpusCustom.nopus_custom_encode(st, MemoryUtil.memAddress((ShortBuffer)pcm), frame_size, MemoryUtil.memAddress((ByteBuffer)compressed), compressed.remaining());
    }

    private static int opus_custom_encoder_ctl(@NativeType(value="OpusCustomEncoder *") long st) {
        long __functionAddress = Functions.custom_encoder_ctl;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePI((long)st, (long)__functionAddress);
    }

    public static int opus_custom_decoder_get_size(@NativeType(value="OpusCustomMode const *") long mode, int channels) {
        long __functionAddress = Functions.custom_decoder_get_size;
        if (Checks.CHECKS) {
            Checks.check((long)mode);
        }
        return JNI.invokePI((long)mode, (int)channels, (long)__functionAddress);
    }

    public static int opus_custom_decoder_init(@NativeType(value="OpusCustomDecoder *") long st, @NativeType(value="OpusCustomMode const *") long mode, int channels) {
        long __functionAddress = Functions.custom_decoder_init;
        if (Checks.CHECKS) {
            Checks.check((long)st);
            Checks.check((long)mode);
        }
        return JNI.invokePPI((long)st, (long)mode, (int)channels, (long)__functionAddress);
    }

    public static long nopus_custom_decoder_create(long mode, int channels, long error) {
        long __functionAddress = Functions.custom_decoder_create;
        if (Checks.CHECKS) {
            Checks.check((long)mode);
        }
        return JNI.invokePPP((long)mode, (int)channels, (long)error, (long)__functionAddress);
    }

    @NativeType(value="OpusCustomDecoder *")
    public static long opus_custom_decoder_create(@NativeType(value="OpusCustomMode const *") long mode, int channels, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, (int)1);
        }
        return OpusCustom.nopus_custom_decoder_create(mode, channels, MemoryUtil.memAddressSafe((IntBuffer)error));
    }

    public static void opus_custom_decoder_destroy(@NativeType(value="OpusCustomDecoder *") long st) {
        long __functionAddress = Functions.custom_decoder_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        JNI.invokePV((long)st, (long)__functionAddress);
    }

    public static int nopus_custom_decode_float(long st, long data, int len, long pcm, int frame_size) {
        long __functionAddress = Functions.custom_decode_float;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)data, (int)len, (long)pcm, (int)frame_size, (long)__functionAddress);
    }

    public static int opus_custom_decode_float(@NativeType(value="OpusCustomDecoder *") long st, @Nullable @NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="float *") FloatBuffer pcm, int frame_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + (long)(Pointer.POINTER_SIZE + 4)))));
        }
        return OpusCustom.nopus_custom_decode_float(st, MemoryUtil.memAddressSafe((ByteBuffer)data), Checks.remainingSafe((Buffer)data), MemoryUtil.memAddress((FloatBuffer)pcm), frame_size);
    }

    public static int nopus_custom_decode(long st, long data, int len, long pcm, int frame_size) {
        long __functionAddress = Functions.custom_decode;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePPPI((long)st, (long)data, (int)len, (long)pcm, (int)frame_size, (long)__functionAddress);
    }

    public static int opus_custom_decode(@NativeType(value="OpusCustomDecoder *") long st, @Nullable @NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int16 *") ShortBuffer pcm, int frame_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, (int)(frame_size * MemoryUtil.memGetInt((long)(st + (long)(Pointer.POINTER_SIZE + 4)))));
        }
        return OpusCustom.nopus_custom_decode(st, MemoryUtil.memAddressSafe((ByteBuffer)data), Checks.remainingSafe((Buffer)data), MemoryUtil.memAddress((ShortBuffer)pcm), frame_size);
    }

    private static int opus_custom_decoder_ctl(@NativeType(value="OpusCustomDecoder *") long st) {
        long __functionAddress = Functions.custom_decoder_ctl;
        if (Checks.CHECKS) {
            Checks.check((long)st);
        }
        return JNI.invokePI((long)st, (long)__functionAddress);
    }

    public static int opus_custom_encoder_ctl(@NativeType(value="OpusCustomEncoder *") long st, int request) {
        return new Opus.CTLRequest(request).apply(st, Functions.custom_encoder_ctl);
    }

    public static int opus_custom_encoder_ctl(@NativeType(value="OpusCustomEncoder *") long st, Opus.CTLRequest request) {
        return request.apply(st, Functions.custom_encoder_ctl);
    }

    public static int opus_custom_decoder_ctl(@NativeType(value="OpusCustomDecoder *") long st, int request) {
        return new Opus.CTLRequest(request).apply(st, Functions.custom_decoder_ctl);
    }

    public static int opus_custom_decoder_ctl(@NativeType(value="OpusCustomDecoder *") long st, Opus.CTLRequest request) {
        return request.apply(st, Functions.custom_decoder_ctl);
    }

    public static final class Functions {
        public static final long custom_mode_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_mode_create");
        public static final long custom_mode_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_mode_destroy");
        public static final long custom_encoder_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encoder_get_size");
        public static final long custom_encoder_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encoder_init");
        public static final long custom_encoder_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encoder_create");
        public static final long custom_encoder_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encoder_destroy");
        public static final long custom_encode_float = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encode_float");
        public static final long custom_encode = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encode");
        public static final long custom_encoder_ctl = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_encoder_ctl");
        public static final long custom_decoder_get_size = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decoder_get_size");
        public static final long custom_decoder_init = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decoder_init");
        public static final long custom_decoder_create = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decoder_create");
        public static final long custom_decoder_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decoder_destroy");
        public static final long custom_decode_float = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decode_float");
        public static final long custom_decode = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decode");
        public static final long custom_decoder_ctl = APIUtil.apiGetFunctionAddress((FunctionProvider)Opus.getLibrary(), (String)"opus_custom_decoder_ctl");

        private Functions() {
        }
    }
}

