/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3UserDataValue")
public class B3UserDataValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_TYPE;
    public static final int M_LENGTH;
    public static final int M_DATA1;

    public B3UserDataValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3UserDataValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_type() {
        return B3UserDataValue.nm_type(this.address());
    }

    public int m_length() {
        return B3UserDataValue.nm_length(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer m_data1() {
        return B3UserDataValue.nm_data1(this.address());
    }

    public B3UserDataValue m_type(int value) {
        B3UserDataValue.nm_type(this.address(), value);
        return this;
    }

    public B3UserDataValue m_data1(@NativeType(value="char *") ByteBuffer value) {
        B3UserDataValue.nm_data1(this.address(), value);
        return this;
    }

    public B3UserDataValue set(int m_type, ByteBuffer m_data1) {
        this.m_type(m_type);
        this.m_data1(m_data1);
        return this;
    }

    public B3UserDataValue set(B3UserDataValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3UserDataValue malloc() {
        return (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3UserDataValue calloc() {
        return (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3UserDataValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3UserDataValue create(long address) {
        return (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)address);
    }

    @Nullable
    public static B3UserDataValue createSafe(long address) {
        return address == 0L ? null : (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3UserDataValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3UserDataValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3UserDataValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3UserDataValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3UserDataValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3UserDataValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3UserDataValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3UserDataValue mallocStack() {
        return B3UserDataValue.mallocStack(MemoryStack.stackGet());
    }

    public static B3UserDataValue callocStack() {
        return B3UserDataValue.callocStack(MemoryStack.stackGet());
    }

    public static B3UserDataValue mallocStack(MemoryStack stack) {
        return (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3UserDataValue callocStack(MemoryStack stack) {
        return (B3UserDataValue)B3UserDataValue.wrap(B3UserDataValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3UserDataValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3UserDataValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3UserDataValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3UserDataValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_TYPE);
    }

    public static int nm_length(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_LENGTH);
    }

    public static ByteBuffer nm_data1(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_DATA1)), (int)B3UserDataValue.nm_length(struct));
    }

    public static void nm_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_TYPE, value);
    }

    public static void nm_length(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_LENGTH, value);
    }

    public static void nm_data1(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_DATA1), (long)MemoryUtil.memAddress((ByteBuffer)value));
        B3UserDataValue.nm_length(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_DATA1)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            B3UserDataValue.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = B3UserDataValue.__struct((Struct.Member[])new Struct.Member[]{B3UserDataValue.__member((int)4), B3UserDataValue.__member((int)4), B3UserDataValue.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_TYPE = layout.offsetof(0);
        M_LENGTH = layout.offsetof(1);
        M_DATA1 = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<B3UserDataValue, Buffer>
    implements NativeResource {
        private static final B3UserDataValue ELEMENT_FACTORY = B3UserDataValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3UserDataValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_type() {
            return B3UserDataValue.nm_type(this.address());
        }

        public int m_length() {
            return B3UserDataValue.nm_length(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer m_data1() {
            return B3UserDataValue.nm_data1(this.address());
        }

        public Buffer m_type(int value) {
            B3UserDataValue.nm_type(this.address(), value);
            return this;
        }

        public Buffer m_data1(@NativeType(value="char *") ByteBuffer value) {
            B3UserDataValue.nm_data1(this.address(), value);
            return this;
        }
    }
}

