/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpSender;
import com.microsoft.azure.eventhubs.impl.BaseLinkHandler;
import java.util.Locale;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendLinkHandler
extends BaseLinkHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(SendLinkHandler.class);
    private final AmqpSender msgSender;
    private final Object firstFlow;
    private boolean isFirstFlow;

    public SendLinkHandler(AmqpSender sender) {
        super(sender);
        this.msgSender = sender;
        this.firstFlow = new Object();
        this.isFirstFlow = true;
    }

    public void onLinkLocalOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Sender) {
            Sender sender = (Sender)link;
            if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format("onLinkLocalOpen linkName[%s], localTarget[%s]", sender.getName(), sender.getTarget()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkRemoteOpen(Event event) {
        Link link = event.getLink();
        if (link instanceof Sender) {
            Sender sender = (Sender)link;
            if (link.getRemoteTarget() != null) {
                if (TRACE_LOGGER.isInfoEnabled()) {
                    TRACE_LOGGER.info(String.format(Locale.US, "onLinkRemoteOpen linkName[%s], remoteTarget[%s]", sender.getName(), link.getRemoteTarget()));
                }
                Object object = this.firstFlow;
                synchronized (object) {
                    this.isFirstFlow = false;
                    this.msgSender.onOpenComplete(null);
                }
            } else if (TRACE_LOGGER.isInfoEnabled()) {
                TRACE_LOGGER.info(String.format(Locale.US, "onLinkRemoteOpen linkName[%s], remoteTarget[null], remoteSource[null], action[waitingForError]", sender.getName()));
            }
        }
    }

    public void onDelivery(Event event) {
        Delivery delivery = event.getDelivery();
        while (delivery != null) {
            Sender sender = (Sender)delivery.getLink();
            if (TRACE_LOGGER.isTraceEnabled()) {
                TRACE_LOGGER.trace("onDelivery linkName[" + sender.getName() + "], unsettled[" + sender.getUnsettled() + "], credit[" + sender.getRemoteCredit() + "], deliveryState[" + delivery.getRemoteState() + "], delivery.isBuffered[" + delivery.isBuffered() + "], delivery.id[" + new String(delivery.getTag()) + "]");
            }
            this.msgSender.onSendComplete(delivery);
            delivery.settle();
            delivery = sender.current();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkFlow(Event event) {
        if (this.isFirstFlow) {
            Object object = this.firstFlow;
            synchronized (object) {
                if (this.isFirstFlow) {
                    this.msgSender.onOpenComplete(null);
                    this.isFirstFlow = false;
                }
            }
        }
        Sender sender = event.getSender();
        this.msgSender.onFlow(sender.getRemoteCredit());
        if (TRACE_LOGGER.isDebugEnabled()) {
            TRACE_LOGGER.debug("onLinkFlow linkName[" + sender.getName() + "], unsettled[" + sender.getUnsettled() + "], credit[" + sender.getCredit() + "]");
        }
    }
}

