/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ListIterator;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PopBackrefFrameInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopBlockFrameInstr;
import org.jruby.ir.instructions.PopMethodFrameInstr;
import org.jruby.ir.instructions.PrepareBlockArgsInstr;
import org.jruby.ir.instructions.PrepareNoBlockArgsInstr;
import org.jruby.ir.instructions.PrepareSingleBlockArgInstr;
import org.jruby.ir.instructions.PushBackrefFrameInstr;
import org.jruby.ir.instructions.PushBlockBindingInstr;
import org.jruby.ir.instructions.PushBlockFrameInstr;
import org.jruby.ir.instructions.PushMethodBindingInstr;
import org.jruby.ir.instructions.PushMethodFrameInstr;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.RestoreBindingVisibilityInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.SaveBindingVisibilityInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.UpdateBlockExecutionStateInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.LiveVariableAnalysis;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.runtime.Signature;
import org.jruby.runtime.Visibility;

public class AddCallProtocolInstructions
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Add Call Protocol Instructions (push/pop of dyn-scope, frame, impl-class values)";
    }

    @Override
    public String getShortLabel() {
        return "Add Call Proto";
    }

    private boolean explicitCallProtocolSupported(IRScope scope) {
        return scope instanceof IRMethod || scope instanceof IRClosure && !(scope instanceof IREvalScript) || scope instanceof IRModuleBody && !(scope instanceof IRMetaClassBody) || scope instanceof IRScriptBody;
    }

    private void fixReturn(FullInterpreterContext fic, ReturnBase i2, ListIterator<Instr> instrs) {
        Operand retVal = i2.getReturnValue();
        if (!(retVal instanceof ImmutableLiteral) && !(retVal instanceof TemporaryVariable)) {
            TemporaryVariable tmp = fic.createTemporaryVariable();
            CopyInstr copy = new CopyInstr(tmp, retVal);
            i2.updateReturnValue(tmp);
            instrs.previous();
            instrs.add(copy);
            instrs.next();
        }
    }

    private void popSavedState(boolean needsOnlyBackref, boolean isClosure, boolean isGEB, boolean requireBinding, boolean needsFrame, Variable savedViz, Variable savedFrame, ListIterator<Instr> instrs) {
        if (isClosure && isGEB) {
            instrs.previous();
        }
        if (requireBinding) {
            instrs.add(new PopBindingInstr());
        }
        if (isClosure) {
            if (needsFrame) {
                instrs.add(new RestoreBindingVisibilityInstr(savedViz));
                instrs.add(new PopBlockFrameInstr(savedFrame));
            }
        } else if (needsFrame) {
            if (needsOnlyBackref) {
                instrs.add(new PopBackrefFrameInstr());
            } else {
                instrs.add(new PopMethodFrameInstr());
            }
        }
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        if (!this.explicitCallProtocolSupported(fic.getScope())) {
            return null;
        }
        CFG cfg = fic.getCFG();
        boolean needsFrame = fic.needsFrame();
        boolean requireBinding = fic.needsBinding();
        boolean isClosure = fic.getScope() instanceof IRClosure;
        boolean needsOnlyBackref = fic.needsOnlyBackref();
        if (isClosure || requireBinding || needsFrame) {
            BasicBlock entryBB = cfg.getEntryBB();
            TemporaryVariable savedViz = null;
            TemporaryVariable savedFrame = null;
            if (isClosure) {
                savedViz = fic.createTemporaryVariable();
                savedFrame = fic.createTemporaryVariable();
                int insertIndex = 0;
                if (needsFrame) {
                    entryBB.insertInstr(insertIndex++, new SaveBindingVisibilityInstr(savedViz));
                    entryBB.insertInstr(insertIndex++, new PushBlockFrameInstr(savedFrame, fic.getName()));
                }
                if (requireBinding) {
                    entryBB.insertInstr(insertIndex++, new PushBlockBindingInstr());
                }
                entryBB.insertInstr(insertIndex++, new UpdateBlockExecutionStateInstr(Self.SELF));
                BasicBlock prologueBB = this.createPrologueBlock(cfg);
                Signature sig = ((IRClosure)fic.getScope()).getSignature();
                int arityValue = sig.arityValue();
                if (arityValue == 0) {
                    prologueBB.addInstr(PrepareNoBlockArgsInstr.INSTANCE);
                } else if (sig.isFixed()) {
                    if (arityValue == 1) {
                        prologueBB.addInstr(PrepareSingleBlockArgInstr.INSTANCE);
                    } else {
                        prologueBB.addInstr(PrepareBlockArgsInstr.INSTANCE);
                    }
                } else {
                    prologueBB.addInstr(PrepareBlockArgsInstr.INSTANCE);
                }
            } else {
                if (needsFrame) {
                    if (needsOnlyBackref) {
                        entryBB.addInstr(new PushBackrefFrameInstr());
                    } else {
                        entryBB.addInstr(new PushMethodFrameInstr(fic.getName(), fic.getScope().isScriptScope() ? Visibility.PRIVATE : Visibility.PUBLIC));
                    }
                }
                if (requireBinding) {
                    entryBB.addInstr(new PushMethodBindingInstr());
                }
            }
            BasicBlock geb = cfg.getGlobalEnsureBB();
            boolean gebProcessed = false;
            if (geb == null) {
                TemporaryVariable exc = fic.createTemporaryVariable();
                geb = new BasicBlock(cfg, Label.getGlobalEnsureBlockLabel());
                geb.addInstr(new ReceiveJRubyExceptionInstr(exc));
                geb.addInstr(new ThrowExceptionInstr(exc));
                cfg.addGlobalEnsureBB(geb);
            }
            for (BasicBlock bb : cfg.getBasicBlocks()) {
                Instr i2 = null;
                ListIterator<Instr> instrs = bb.getInstrs().listIterator();
                while (instrs.hasNext()) {
                    i2 = instrs.next();
                    if (bb.isExitBB() || !(i2 instanceof ReturnInstr)) continue;
                    if (needsFrame || requireBinding) {
                        this.fixReturn(fic, (ReturnInstr)i2, instrs);
                    }
                    i2 = instrs.previous();
                    this.popSavedState(needsOnlyBackref, isClosure, bb == geb, requireBinding, needsFrame, savedViz, savedFrame, instrs);
                    if (bb != geb) break;
                    gebProcessed = true;
                    break;
                }
                if (bb.isExitBB() && !bb.isEmpty()) {
                    if (i2 != null && i2 instanceof ReturnInstr) {
                        if (needsFrame || requireBinding) {
                            this.fixReturn(fic, (ReturnInstr)i2, instrs);
                        }
                        instrs.previous();
                    }
                    this.popSavedState(needsOnlyBackref, isClosure, bb == geb, requireBinding, needsFrame, savedViz, savedFrame, instrs);
                    if (bb != geb) continue;
                    gebProcessed = true;
                    continue;
                }
                if (gebProcessed || bb != geb) continue;
                if (i2 != null) {
                    assert (i2.getOperation().transfersControl()) : "Last instruction of GEB in scope: " + fic.getScope() + " is " + i2 + ", not a control-xfer instruction";
                    instrs.previous();
                }
                this.popSavedState(needsOnlyBackref, isClosure, true, requireBinding, needsFrame, savedViz, savedFrame, instrs);
            }
        }
        fic.setExplicitCallProtocol(true);
        new LiveVariableAnalysis().invalidate(fic);
        return null;
    }

    private BasicBlock createPrologueBlock(CFG cfg) {
        BasicBlock entryBB = cfg.getEntryBB();
        BasicBlock oldStart = cfg.getOutgoingDestinationOfType(entryBB, (Object)CFG.EdgeType.FALL_THROUGH);
        BasicBlock prologueBB = new BasicBlock(cfg, cfg.getScope().getNewLabel());
        cfg.removeEdge(entryBB, oldStart);
        cfg.addBasicBlock(prologueBB);
        cfg.addEdge(entryBB, prologueBB, (Object)CFG.EdgeType.FALL_THROUGH);
        cfg.addEdge(prologueBB, oldStart, (Object)CFG.EdgeType.FALL_THROUGH);
        if (cfg.getGlobalEnsureBB() != null) {
            BasicBlock geb = cfg.getGlobalEnsureBB();
            cfg.addEdge(prologueBB, geb, (Object)CFG.EdgeType.EXCEPTION);
            cfg.setRescuerBB(prologueBB, geb);
        }
        return prologueBB;
    }

    @Override
    public boolean invalidate(FullInterpreterContext fic) {
        return false;
    }
}

