/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.configuration;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.Manifest;
import javax.swing.UIManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.service.configuration.ConfigurationPersister;
import org.jd.gui.service.platform.PlatformService;
import org.jd.gui.util.exception.ExceptionUtil;

public class ConfigurationXmlPersisterProvider
implements ConfigurationPersister {
    protected static final String ERROR_BACKGROUND_COLOR = "JdGuiPreferences.errorBackgroundColor";
    protected static final String JD_CORE_VERSION = "JdGuiPreferences.jdCoreVersion";
    protected static final File FILE = ConfigurationXmlPersisterProvider.getConfigFile();

    protected static File getConfigFile() {
        File roamingConfigHomeFile;
        String roamingConfigHome;
        File configFile;
        String configFilePath = System.getProperty("jd-gui.cfg");
        if (configFilePath != null && (configFile = new File(configFilePath)).exists()) {
            return configFile;
        }
        if (PlatformService.getInstance().isLinux()) {
            File xdgConfigHomeFile;
            String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
            if (xdgConfigHome != null && (xdgConfigHomeFile = new File(xdgConfigHome)).exists()) {
                return new File(xdgConfigHomeFile, "jd-gui.cfg");
            }
            File userConfigFile = new File(System.getProperty("user.home"), ".config");
            if (userConfigFile.exists()) {
                return new File(userConfigFile, "jd-gui.cfg");
            }
        } else if (PlatformService.getInstance().isWindows() && (roamingConfigHome = System.getenv("APPDATA")) != null && (roamingConfigHomeFile = new File(roamingConfigHome)).exists()) {
            return new File(roamingConfigHomeFile, "jd-gui.cfg");
        }
        return new File("jd-gui.cfg");
    }

    @Override
    public Configuration load() {
        Configuration config;
        block46: {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int w = screenSize.width > 600 ? 600 : screenSize.width;
            int h = screenSize.height > 400 ? 400 : screenSize.height;
            int x = (screenSize.width - w) / 2;
            int y = (screenSize.height - h) / 2;
            config = new Configuration();
            config.setMainWindowLocation(new Point(x, y));
            config.setMainWindowSize(new Dimension(w, h));
            config.setMainWindowMaximize(false);
            String defaultLaf = System.getProperty("swing.defaultlaf");
            config.setLookAndFeel(defaultLaf != null ? defaultLaf : UIManager.getSystemLookAndFeelClassName());
            File recentSaveDirectory = new File(System.getProperty("user.dir"));
            config.setRecentLoadDirectory(recentSaveDirectory);
            config.setRecentSaveDirectory(recentSaveDirectory);
            if (FILE.exists()) {
                try (FileInputStream fis = new FileInputStream(FILE);){
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(fis);
                    String name = "";
                    Stack<String> names = new Stack<String>();
                    List<File> recentFiles = new ArrayList<File>();
                    boolean maximize = false;
                    Map<String, String> preferences = config.getPreferences();
                    while (reader.hasNext()) {
                        block5 : switch (reader.next()) {
                            case 1: {
                                names.push(name);
                                switch (name = name + '/' + reader.getLocalName()) {
                                    case "/configuration/gui/mainWindow/location": {
                                        x = Integer.parseInt(reader.getAttributeValue(null, "x"));
                                        y = Integer.parseInt(reader.getAttributeValue(null, "y"));
                                        break block5;
                                    }
                                    case "/configuration/gui/mainWindow/size": {
                                        w = Integer.parseInt(reader.getAttributeValue(null, "w"));
                                        h = Integer.parseInt(reader.getAttributeValue(null, "h"));
                                    }
                                }
                                break;
                            }
                            case 2: {
                                name = (String)names.pop();
                                break;
                            }
                            case 4: {
                                switch (name) {
                                    case "/configuration/recentFilePaths/filePath": {
                                        File file = new File(reader.getText().trim());
                                        if (!file.exists()) break block5;
                                        recentFiles.add(file);
                                        break block5;
                                    }
                                    case "/configuration/recentDirectories/loadPath": {
                                        File file = new File(reader.getText().trim());
                                        if (!file.exists()) break block5;
                                        config.setRecentLoadDirectory(file);
                                        break block5;
                                    }
                                    case "/configuration/recentDirectories/savePath": {
                                        File file = new File(reader.getText().trim());
                                        if (!file.exists()) break block5;
                                        config.setRecentSaveDirectory(file);
                                        break block5;
                                    }
                                    case "/configuration/gui/lookAndFeel": {
                                        config.setLookAndFeel(reader.getText().trim());
                                        break block5;
                                    }
                                    case "/configuration/gui/mainWindow/maximize": {
                                        maximize = Boolean.parseBoolean(reader.getText().trim());
                                        break block5;
                                    }
                                }
                                if (!name.startsWith("/configuration/preferences/")) break;
                                String key = name.substring("/configuration/preferences/".length());
                                preferences.put(key, reader.getText().trim());
                            }
                        }
                    }
                    if (recentFiles.size() > 10) {
                        recentFiles = recentFiles.subList(0, 10);
                    }
                    config.setRecentFiles(recentFiles);
                    if (x >= 0 && y >= 0 && x + w < screenSize.width && y + h < screenSize.height) {
                        config.setMainWindowLocation(new Point(x, y));
                        config.setMainWindowSize(new Dimension(w, h));
                        config.setMainWindowMaximize(maximize);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block46;
                    throw new AssertionError();
                }
            }
        }
        if (!config.getPreferences().containsKey(ERROR_BACKGROUND_COLOR)) {
            config.getPreferences().put(ERROR_BACKGROUND_COLOR, "0xFF6666");
        }
        config.getPreferences().put(JD_CORE_VERSION, this.getJdCoreVersion());
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getJdCoreVersion() {
        try {
            Enumeration<URL> enumeration = ConfigurationXmlPersisterProvider.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                InputStream is = enumeration.nextElement().openStream();
                Throwable throwable = null;
                try {
                    String attribute = new Manifest(is).getMainAttributes().getValue("JD-Core-Version");
                    if (attribute == null) continue;
                    String string = attribute;
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            return "SNAPSHOT";
        }
        catch (IOException e) {
            if ($assertionsDisabled) return "SNAPSHOT";
            if (ExceptionUtil.printStackTrace(e)) return "SNAPSHOT";
            throw new AssertionError();
        }
    }

    @Override
    public void save(Configuration configuration) {
        block16: {
            Point l = configuration.getMainWindowLocation();
            Dimension s = configuration.getMainWindowSize();
            try (FileOutputStream fos = new FileOutputStream(FILE);){
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fos);
                writer.writeStartDocument();
                writer.writeCharacters("\n");
                writer.writeStartElement("configuration");
                writer.writeCharacters("\n\t");
                writer.writeStartElement("gui");
                writer.writeCharacters("\n\t\t");
                writer.writeStartElement("mainWindow");
                writer.writeCharacters("\n\t\t\t");
                writer.writeStartElement("location");
                writer.writeAttribute("x", String.valueOf(l.x));
                writer.writeAttribute("y", String.valueOf(l.y));
                writer.writeEndElement();
                writer.writeCharacters("\n\t\t\t");
                writer.writeStartElement("size");
                writer.writeAttribute("w", String.valueOf(s.width));
                writer.writeAttribute("h", String.valueOf(s.height));
                writer.writeEndElement();
                writer.writeCharacters("\n\t\t\t");
                writer.writeStartElement("maximize");
                writer.writeCharacters(String.valueOf(configuration.isMainWindowMaximize()));
                writer.writeEndElement();
                writer.writeCharacters("\n\t\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t\t");
                writer.writeStartElement("lookAndFeel");
                writer.writeCharacters(configuration.getLookAndFeel());
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeStartElement("recentFilePaths");
                for (File file : configuration.getRecentFiles()) {
                    writer.writeCharacters("\n\t\t");
                    writer.writeStartElement("filePath");
                    writer.writeCharacters(file.getAbsolutePath());
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeStartElement("recentDirectories");
                writer.writeCharacters("\n\t\t");
                writer.writeStartElement("loadPath");
                writer.writeCharacters(configuration.getRecentLoadDirectory().getAbsolutePath());
                writer.writeEndElement();
                writer.writeCharacters("\n\t\t");
                writer.writeStartElement("savePath");
                writer.writeCharacters(configuration.getRecentSaveDirectory().getAbsolutePath());
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeStartElement("preferences");
                for (Map.Entry entry : configuration.getPreferences().entrySet()) {
                    writer.writeCharacters("\n\t\t");
                    writer.writeStartElement((String)entry.getKey());
                    writer.writeCharacters((String)entry.getValue());
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n");
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.close();
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block16;
                throw new AssertionError();
            }
        }
    }
}

