/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;

import java.io.IOException;

public class NullSectionProvider implements DWARFSectionProvider {

	public NullSectionProvider() {
		// nothing
	}

	@Override
	public ByteProvider getSectionAsByteProvider(String sectionName) throws IOException {
		return new ByteArrayProvider(new byte[] {});
	}

	@Override
	public boolean hasSection(String... sectionNames) {
		return true;
	}

	@Override
	public void close() {
		// nothing
	}

}
