/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ColumnAdapter;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class DbSmallTableModel
implements TableModel {
    ArrayList<TableModelListener> listeners = new ArrayList();
    Table table;
    Schema schema;
    ColumnAdapter[] colAdapters;
    ColumnAdapter keyAdapter;
    Record[] records;

    DbSmallTableModel(Table table) {
        this.table = table;
        this.schema = table.getSchema();
        this.records = new Record[table.getRecordCount()];
        this.keyAdapter = new ColumnAdapter(this.schema.getKeyFieldClass());
        this.colAdapters = new ColumnAdapter[this.schema.getFieldCount()];
        Class[] classes = this.schema.getFieldClasses();
        for (int i = 0; i < this.colAdapters.length; ++i) {
            this.colAdapters[i] = new ColumnAdapter(classes[i]);
        }
        try {
            RecordIterator it = table.iterator();
            for (int i = 0; i < this.records.length; ++i) {
                this.records[i] = it.next();
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return this.keyAdapter.getValueClass();
        }
        return this.colAdapters[columnIndex - 1].getValueClass();
    }

    @Override
    public int getColumnCount() {
        return this.schema.getFieldCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return this.schema.getKeyName();
        }
        --columnIndex;
        int[] indexCols = this.table.getIndexedColumns();
        boolean isIndexed = false;
        for (int indexCol : indexCols) {
            if (indexCol != columnIndex) continue;
            isIndexed = true;
            break;
        }
        return this.schema.getFieldNames()[columnIndex] + (isIndexed ? "*" : "");
    }

    @Override
    public int getRowCount() {
        return this.table.getRecordCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Record rec = this.records[rowIndex];
        if (columnIndex == 0) {
            return this.keyAdapter.getKeyValue(rec);
        }
        return this.colAdapters[columnIndex - 1].getValue(rec, columnIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

