/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.ByteField;
import db.DBHandle;
import db.IntField;
import db.LongField;
import db.OpenMode;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.util.TableColumn;
import db.util.TableDescriptor;
import ghidra.feature.vt.api.db.VTAssociationTableDBAdapterV0;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

public abstract class VTAssociationTableDBAdapter {
    static String TABLE_NAME = "AssociationTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", AssociationTableDescriptor.INSTANCE.getColumnClasses(), AssociationTableDescriptor.INSTANCE.getColumnNames());
    static int[] TABLE_INDEXES = AssociationTableDescriptor.INSTANCE.getIndexedColumns();

    public static VTAssociationTableDBAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTAssociationTableDBAdapterV0(dbHandle);
    }

    static VTAssociationTableDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTAssociationTableDBAdapterV0(dbHandle, openMode, monitor);
    }

    abstract Record insertRecord(long var1, long var3, VTAssociationType var5, VTAssociationStatus var6, int var7) throws IOException;

    abstract void deleteRecord(long var1) throws IOException;

    abstract RecordIterator getRecordsForSourceAddress(long var1) throws IOException;

    abstract RecordIterator getRecordsForDestinationAddress(long var1) throws IOException;

    abstract int getRecordCount();

    abstract RecordIterator getRecords() throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract Set<Record> getRelatedAssociationRecordsBySourceAndDestinationAddress(long var1, long var3) throws IOException;

    abstract Set<Record> getRelatedAssociationRecordsBySourceAddress(long var1) throws IOException;

    abstract Set<Record> getRelatedAssociationRecordsByDestinationAddress(long var1) throws IOException;

    abstract void updateRecord(Record var1) throws IOException;

    abstract void removeAssociaiton(long var1) throws IOException;

    public static class AssociationTableDescriptor
    extends TableDescriptor {
        public static TableColumn SOURCE_ADDRESS_COL = new TableColumn(LongField.class, true);
        public static TableColumn DESTINATION_ADDRESS_COL = new TableColumn(LongField.class, true);
        public static TableColumn TYPE_COL = new TableColumn(ByteField.class);
        public static TableColumn STATUS_COL = new TableColumn(ByteField.class);
        public static TableColumn APPLIED_STATUS_COL = new TableColumn(ByteField.class);
        public static TableColumn VOTE_COUNT_COL = new TableColumn(IntField.class);
        public static AssociationTableDescriptor INSTANCE = new AssociationTableDescriptor();
    }
}

