/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.ProjectDataTreeActionContext;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyCutBaseAction;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class ProjectDataCutAction
extends ProjectDataCopyCutBaseAction {
    private static Icon icon = ResourceManager.loadImage((String)"images/edit-cut22.png");

    public ProjectDataCutAction(String owner, String group) {
        super("Cut", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Cut"}, icon, group));
        this.setKeyBindingData(new KeyBindingData('X', 128));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataTreeActionContext context) {
        TreePath[] paths = this.adjustSelectionPaths(context.getSelectionPaths());
        DataTreeClipboardUtils.setClipboardContents(context.getTree(), paths);
        this.markNodesCut(paths);
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataTreeActionContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        return !context.containsRootFolder();
    }

    private void markNodesCut(TreePath[] paths) {
        for (TreePath treePath : paths) {
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            if (!(node instanceof Cuttable)) continue;
            ((Cuttable)node).setIsCut(true);
        }
    }
}

