/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.baksmali.baksmali;
import org.jf.baksmali.dump;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.util.ConsoleUtil;
import org.jf.util.SmaliHelpFormatter;

public class main {
    public static final String VERSION;
    private static final Options basicOptions;
    private static final Options debugOptions;
    private static final Options options;
    public static final int ALL = 1;
    public static final int ALLPRE = 2;
    public static final int ALLPOST = 4;
    public static final int ARGS = 8;
    public static final int DEST = 16;
    public static final int MERGE = 32;
    public static final int FULLMERGE = 64;

    private main() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Locale locale = new Locale("en", "US");
        Locale.setDefault(locale);
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException ex) {
            main.usage();
            return;
        }
        boolean disassemble = true;
        boolean doDump = false;
        boolean write = false;
        boolean sort = false;
        boolean fixRegisters = false;
        boolean noParameterRegisters = false;
        boolean useLocalsDirective = false;
        boolean useSequentialLabels = false;
        boolean outputDebugInfo = true;
        boolean addCodeOffsets = false;
        boolean noAccessorComments = false;
        boolean deodex = false;
        boolean verify = false;
        boolean ignoreErrors = false;
        boolean checkPackagePrivateAccess = false;
        int apiLevel = 14;
        int registerInfo = 0;
        String outputDirectory = "out";
        String dumpFileName = null;
        String outputDexFileName = null;
        String inputDexFileName = null;
        String bootClassPath = null;
        StringBuffer extraBootClassPathEntries = new StringBuffer();
        ArrayList<String> bootClassPathDirs = new ArrayList<String>();
        bootClassPathDirs.add(".");
        String inlineTable = null;
        boolean jumboInstructions = false;
        String[] remainingArgs = commandLine.getArgs();
        Option[] options = commandLine.getOptions();
        block33: for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'v': {
                    main.version();
                    return;
                }
                case '?': {
                    while (++i < options.length) {
                        if (options[i].getOpt().charAt(0) != '?') continue;
                        main.usage(true);
                        return;
                    }
                    main.usage(false);
                    return;
                }
                case 'o': {
                    outputDirectory = commandLine.getOptionValue("o");
                    continue block33;
                }
                case 'p': {
                    noParameterRegisters = true;
                    continue block33;
                }
                case 'l': {
                    useLocalsDirective = true;
                    continue block33;
                }
                case 's': {
                    useSequentialLabels = true;
                    continue block33;
                }
                case 'b': {
                    outputDebugInfo = false;
                    continue block33;
                }
                case 'd': {
                    bootClassPathDirs.add(option.getValue());
                    continue block33;
                }
                case 'f': {
                    addCodeOffsets = true;
                    continue block33;
                }
                case 'r': {
                    String[] values = commandLine.getOptionValues('r');
                    if (values == null || values.length == 0) {
                        registerInfo = 24;
                        continue block33;
                    }
                    for (String value : values) {
                        if (value.equalsIgnoreCase("ALL")) {
                            registerInfo |= 1;
                            continue;
                        }
                        if (value.equalsIgnoreCase("ALLPRE")) {
                            registerInfo |= 2;
                            continue;
                        }
                        if (value.equalsIgnoreCase("ALLPOST")) {
                            registerInfo |= 4;
                            continue;
                        }
                        if (value.equalsIgnoreCase("ARGS")) {
                            registerInfo |= 8;
                            continue;
                        }
                        if (value.equalsIgnoreCase("DEST")) {
                            registerInfo |= 0x10;
                            continue;
                        }
                        if (value.equalsIgnoreCase("MERGE")) {
                            registerInfo |= 0x20;
                            continue;
                        }
                        if (value.equalsIgnoreCase("FULLMERGE")) {
                            registerInfo |= 0x40;
                            continue;
                        }
                        main.usage();
                        return;
                    }
                    if ((registerInfo & 0x40) == 0) continue block33;
                    registerInfo &= 0xFFFFFFDF;
                    continue block33;
                }
                case 'c': {
                    String bcp = commandLine.getOptionValue("c");
                    if (bcp != null && bcp.charAt(0) == ':') {
                        extraBootClassPathEntries.append(bcp);
                        continue block33;
                    }
                    bootClassPath = bcp;
                    continue block33;
                }
                case 'x': {
                    deodex = true;
                    continue block33;
                }
                case 'm': {
                    noAccessorComments = true;
                    continue block33;
                }
                case 'a': {
                    apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    if (apiLevel < 17) continue block33;
                    checkPackagePrivateAccess = true;
                    continue block33;
                }
                case 'N': {
                    disassemble = false;
                    continue block33;
                }
                case 'D': {
                    doDump = true;
                    dumpFileName = commandLine.getOptionValue("D", inputDexFileName + ".dump");
                    continue block33;
                }
                case 'I': {
                    ignoreErrors = true;
                    continue block33;
                }
                case 'J': {
                    jumboInstructions = true;
                    continue block33;
                }
                case 'W': {
                    write = true;
                    outputDexFileName = commandLine.getOptionValue("W");
                    continue block33;
                }
                case 'S': {
                    sort = true;
                    continue block33;
                }
                case 'F': {
                    fixRegisters = true;
                    continue block33;
                }
                case 'V': {
                    verify = true;
                    continue block33;
                }
                case 'T': {
                    inlineTable = commandLine.getOptionValue("T");
                    continue block33;
                }
                case 'K': {
                    checkPackagePrivateAccess = true;
                    continue block33;
                }
                default: {
                    assert (false);
                    continue block33;
                }
            }
        }
        if (remainingArgs.length != 1) {
            main.usage();
            return;
        }
        inputDexFileName = remainingArgs[0];
        try {
            File dexFileFile = new File(inputDexFileName);
            if (!dexFileFile.exists()) {
                System.err.println("Can't find the file " + inputDexFileName);
                System.exit(1);
            }
            Opcode.updateMapsForApiLevel((int)apiLevel, (boolean)jumboInstructions);
            DexFile dexFile = new DexFile(dexFileFile, !fixRegisters, false);
            if (dexFile.isOdex()) {
                if (doDump) {
                    System.err.println("-D cannot be used with on odex file. Ignoring -D");
                }
                if (write) {
                    System.err.println("-W cannot be used with an odex file. Ignoring -W");
                }
                if (!deodex) {
                    System.err.println("Warning: You are disassembling an odex file without deodexing it. You");
                    System.err.println("won't be able to re-assemble the results unless you deodex it with the -x");
                    System.err.println("option");
                }
            } else {
                deodex = false;
                if (bootClassPath == null) {
                    bootClassPath = "core.jar:ext.jar:framework.jar:android.policy.jar:services.jar";
                }
            }
            if (disassemble) {
                String[] bootClassPathDirsArray = new String[bootClassPathDirs.size()];
                for (int i = 0; i < bootClassPathDirsArray.length; ++i) {
                    bootClassPathDirsArray[i] = (String)bootClassPathDirs.get(i);
                }
                baksmali.disassembleDexFile(dexFileFile.getPath(), dexFile, deodex, outputDirectory, bootClassPathDirsArray, bootClassPath, extraBootClassPathEntries.toString(), noParameterRegisters, useLocalsDirective, useSequentialLabels, outputDebugInfo, addCodeOffsets, noAccessorComments, registerInfo, verify, ignoreErrors, inlineTable, checkPackagePrivateAccess);
            }
            if ((doDump || write) && !dexFile.isOdex()) {
                try {
                    dump.dump(dexFile, dumpFileName, outputDexFileName, sort);
                }
                catch (IOException ex) {
                    System.err.println("Error occured while writing dump file");
                    ex.printStackTrace();
                }
            }
        }
        catch (RuntimeException ex) {
            System.err.println("\n\nUNEXPECTED TOP-LEVEL EXCEPTION:");
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Throwable ex) {
            System.err.println("\n\nUNEXPECTED TOP-LEVEL ERROR:");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage(boolean printDebugOptions) {
        SmaliHelpFormatter formatter = new SmaliHelpFormatter();
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        formatter.setWidth(consoleWidth);
        formatter.printHelp("java -jar baksmali.jar [options] <dex-file>", "disassembles and/or dumps a dex file", basicOptions, (Options)(printDebugOptions ? debugOptions : null));
    }

    private static void usage() {
        main.usage(false);
    }

    protected static void version() {
        System.out.println("baksmali " + VERSION + " (http://smali.googlecode.com)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"prints the version then exits");
        Option versionOption = OptionBuilder.create((String)"v");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"prints the help message then exits. Specify twice for debug options");
        Option helpOption = OptionBuilder.create((String)"?");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"the directory where the disassembled files will be placed. The default is out");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option outputDirOption = OptionBuilder.create((String)"o");
        OptionBuilder.withLongOpt((String)"no-parameter-registers");
        OptionBuilder.withDescription((String)"use the v<n> syntax instead of the p<n> syntax for registers mapped to method parameters");
        Option noParameterRegistersOption = OptionBuilder.create((String)"p");
        OptionBuilder.withLongOpt((String)"deodex");
        OptionBuilder.withDescription((String)"deodex the given odex file. This option is ignored if the input file is not an odex file");
        Option deodexerantOption = OptionBuilder.create((String)"x");
        OptionBuilder.withLongOpt((String)"use-locals");
        OptionBuilder.withDescription((String)"output the .locals directive with the number of non-parameter registers, rather than the .register directive with the total number of register");
        Option useLocalsOption = OptionBuilder.create((String)"l");
        OptionBuilder.withLongOpt((String)"sequential-labels");
        OptionBuilder.withDescription((String)"create label names using a sequential numbering scheme per label type, rather than using the bytecode address");
        Option sequentialLabelsOption = OptionBuilder.create((String)"s");
        OptionBuilder.withLongOpt((String)"no-debug-info");
        OptionBuilder.withDescription((String)"don't write out debug info (.local, .param, .line, etc.)");
        Option noDebugInfoOption = OptionBuilder.create((String)"b");
        OptionBuilder.withLongOpt((String)"register-info");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"REGISTER_INFO_TYPES");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"print the specificed type(s) of register information for each instruction. \"ARGS,DEST\" is the default if no types are specified.\nValid values are:\nALL: all pre- and post-instruction registers.\nALLPRE: all pre-instruction registers\nALLPOST: all post-instruction registers\nARGS: any pre-instruction registers used as arguments to the instruction\nDEST: the post-instruction destination register, if any\nMERGE: Any pre-instruction register has been merged from more than 1 different post-instruction register from its predecessors\nFULLMERGE: For each register that would be printed by MERGE, also show the incoming register types that were merged");
        Option registerInfoOption = OptionBuilder.create((String)"r");
        OptionBuilder.withLongOpt((String)"bootclasspath");
        OptionBuilder.withDescription((String)"the bootclasspath jars to use, for analysis. Defaults to core.jar:ext.jar:framework.jar:android.policy.jar:services.jar. If the value begins with a :, it will be appended to the default bootclasspath instead of replacing it");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"BOOTCLASSPATH");
        Option classPathOption = OptionBuilder.create((String)"c");
        OptionBuilder.withLongOpt((String)"bootclasspath-dir");
        OptionBuilder.withDescription((String)"the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option classPathDirOption = OptionBuilder.create((String)"d");
        OptionBuilder.withLongOpt((String)"code-offsets");
        OptionBuilder.withDescription((String)"add comments to the disassembly containing the code offset for each address");
        Option codeOffsetOption = OptionBuilder.create((String)"f");
        OptionBuilder.withLongOpt((String)"no-accessor-comments");
        OptionBuilder.withDescription((String)"don't output helper comments for synthetic accessors");
        Option noAccessorCommentsOption = OptionBuilder.create((String)"m");
        OptionBuilder.withLongOpt((String)"api-level");
        OptionBuilder.withDescription((String)"The numeric api-level of the file being disassembled. If not specified, it defaults to 14 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"API_LEVEL");
        Option apiLevelOption = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"dump-to");
        OptionBuilder.withDescription((String)"dumps the given dex file into a single annotated dump file named FILE (<dexfile>.dump by default), along with the normal disassembly");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"FILE");
        Option dumpOption = OptionBuilder.create((String)"D");
        OptionBuilder.withLongOpt((String)"ignore-errors");
        OptionBuilder.withDescription((String)"ignores any non-fatal errors that occur while disassembling/deodexing, ignoring the class if needed, and continuing with the next class. The default behavior is to stop disassembling and exit once an error is encountered");
        Option ignoreErrorsOption = OptionBuilder.create((String)"I");
        OptionBuilder.withLongOpt((String)"jumbo-instructions");
        OptionBuilder.withDescription((String)"adds support for the jumbo opcodes that were temporarily available around the ics timeframe. Note that support for these opcodes was removed from newer version of dalvik. You shouldn't use this option unless you know the dex file contains these jumbo opcodes.");
        Option jumboInstructionsOption = OptionBuilder.create((String)"J");
        OptionBuilder.withLongOpt((String)"no-disassembly");
        OptionBuilder.withDescription((String)"suppresses the output of the disassembly");
        Option noDisassemblyOption = OptionBuilder.create((String)"N");
        OptionBuilder.withLongOpt((String)"write-dex");
        OptionBuilder.withDescription((String)"additionally rewrites the input dex file to FILE");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option writeDexOption = OptionBuilder.create((String)"W");
        OptionBuilder.withLongOpt((String)"sort");
        OptionBuilder.withDescription((String)"sort the items in the dex file into a canonical order before dumping/writing");
        Option sortOption = OptionBuilder.create((String)"S");
        OptionBuilder.withLongOpt((String)"fix-signed-registers");
        OptionBuilder.withDescription((String)"when dumping or rewriting, fix any registers in the debug info that are encoded as a signed value");
        Option fixSignedRegisterOption = OptionBuilder.create((String)"F");
        OptionBuilder.withLongOpt((String)"verify");
        OptionBuilder.withDescription((String)"perform bytecode verification");
        Option verifyDexOption = OptionBuilder.create((String)"V");
        OptionBuilder.withLongOpt((String)"inline-table");
        OptionBuilder.withDescription((String)"specify a file containing a custom inline method table to use for deodexing");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option inlineTableOption = OptionBuilder.create((String)"T");
        basicOptions.addOption(versionOption);
        basicOptions.addOption(helpOption);
        basicOptions.addOption(outputDirOption);
        basicOptions.addOption(noParameterRegistersOption);
        basicOptions.addOption(deodexerantOption);
        basicOptions.addOption(useLocalsOption);
        basicOptions.addOption(sequentialLabelsOption);
        basicOptions.addOption(noDebugInfoOption);
        basicOptions.addOption(registerInfoOption);
        basicOptions.addOption(classPathOption);
        basicOptions.addOption(classPathDirOption);
        basicOptions.addOption(codeOffsetOption);
        basicOptions.addOption(noAccessorCommentsOption);
        basicOptions.addOption(apiLevelOption);
        debugOptions.addOption(dumpOption);
        debugOptions.addOption(ignoreErrorsOption);
        debugOptions.addOption(jumboInstructionsOption);
        debugOptions.addOption(noDisassemblyOption);
        debugOptions.addOption(writeDexOption);
        debugOptions.addOption(sortOption);
        debugOptions.addOption(fixSignedRegisterOption);
        debugOptions.addOption(verifyDexOption);
        debugOptions.addOption(inlineTableOption);
        for (Object option : basicOptions.getOptions()) {
            options.addOption((Option)option);
        }
        for (Object option : debugOptions.getOptions()) {
            options.addOption((Option)option);
        }
    }

    static {
        options = new Options();
        basicOptions = new Options();
        debugOptions = new Options();
        main.buildOptions();
        InputStream templateStream = baksmali.class.getClassLoader().getResourceAsStream("baksmali.properties");
        Properties properties = new Properties();
        String version = "(unknown)";
        try {
            properties.load(templateStream);
            version = properties.getProperty("application.version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VERSION = version;
    }
}

