/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.io.Writer;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.Utf8Utils;
import org.jf.util.IndentingWriter;

public abstract class DebugMethodItem
extends MethodItem {
    private final double sortOrder;

    public DebugMethodItem(int codeAddress, double sortOrder) {
        super(codeAddress);
        this.sortOrder = sortOrder;
    }

    @Override
    public double getSortOrder() {
        return this.sortOrder;
    }

    protected static void writeLine(IndentingWriter writer, int line) throws IOException {
        writer.write(".line ");
        writer.printSignedIntAsDec(line);
    }

    protected static void writeEndPrologue(IndentingWriter writer) throws IOException {
        writer.write(".prologue");
    }

    protected static void writeBeginEpilogue(IndentingWriter writer) throws IOException {
        writer.write(".epilogue");
    }

    protected static void writeStartLocal(IndentingWriter writer, CodeItem codeItem, int register, StringIdItem name, TypeIdItem type, StringIdItem signature) throws IOException {
        writer.write(".local ");
        RegisterFormatter.writeTo(writer, codeItem, register);
        writer.write(", ");
        writer.write(name.getStringValue());
        writer.write(58);
        writer.write(type.getTypeDescriptor());
        if (signature != null) {
            writer.write(",\"");
            writer.write(signature.getStringValue());
            writer.write(34);
        }
    }

    protected static void writeEndLocal(IndentingWriter writer, CodeItem codeItem, int register, StringIdItem name, TypeIdItem type, StringIdItem signature) throws IOException {
        writer.write(".end local ");
        RegisterFormatter.writeTo(writer, codeItem, register);
        if (name != null) {
            writer.write("           #");
            writer.write(name.getStringValue());
            writer.write(58);
            writer.write(type.getTypeDescriptor());
            if (signature != null) {
                writer.write(",\"");
                writer.write(signature.getStringValue());
                writer.write(34);
            }
        }
    }

    protected static void writeRestartLocal(IndentingWriter writer, CodeItem codeItem, int register, StringIdItem name, TypeIdItem type, StringIdItem signature) throws IOException {
        writer.write(".restart local ");
        RegisterFormatter.writeTo(writer, codeItem, register);
        if (name != null) {
            writer.write("       #");
            writer.write(name.getStringValue());
            writer.write(58);
            writer.write(type.getTypeDescriptor());
            if (signature != null) {
                writer.write(",\"");
                writer.write(signature.getStringValue());
                writer.write(34);
            }
        }
    }

    protected static void writeSetFile(IndentingWriter writer, String fileName) throws IOException {
        writer.write(".source \"");
        Utf8Utils.writeEscapedString((Writer)writer, (String)fileName);
        writer.write(34);
    }
}

