/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.functiontype.MDFunctionType;

public class MDFuzzyFit {
    private int numCharsRemaining = 0;
    private List<Class<? extends MDParsableItem>> classList = new ArrayList<Class<? extends MDParsableItem>>();

    public MDFuzzyFit() {
        this.classList.add(MDType.class);
        this.classList.add(MDDataType.class);
        this.classList.add(MDFunctionType.class);
    }

    public boolean fuzz(String mangledArg) {
        StringBuilder outputBuilder = new StringBuilder();
        if (mangledArg == null) {
            return false;
        }
        MDMang dmang = new MDMang();
        int offset = mangledArg.length();
        outputBuilder.append("Symbol: ");
        outputBuilder.append(mangledArg);
        while (--offset >= 0) {
            try {
                String substring = mangledArg.substring(offset);
                for (Class<? extends MDParsableItem> tryClass : this.classList) {
                    boolean pass = true;
                    try {
                        dmang.setMangledSymbol(substring);
                        dmang.pushContext();
                        this.numCharsRemaining = substring.length();
                        MDParsableItem tryItem = tryClass.newInstance();
                        tryItem.setMDMang(dmang);
                        tryItem.parse();
                        this.numCharsRemaining = dmang.getNumCharsRemaining();
                        dmang.popContext();
                        StringBuilder builder = new StringBuilder();
                        tryItem.insert(builder);
                        String substringDemangled = builder.toString();
                        if (this.numCharsRemaining == 0) {
                            outputBuilder.append("Offset: ");
                            outputBuilder.append(offset);
                            outputBuilder.append("; Class: ");
                            outputBuilder.append(tryClass.getSimpleName());
                            outputBuilder.append("; Output:");
                            outputBuilder.append(substringDemangled);
                        }
                    }
                    catch (MDException e) {
                        pass = false;
                    }
                    outputBuilder.append("Offset: ");
                    outputBuilder.append(offset);
                    outputBuilder.append("; Class: ");
                    outputBuilder.append(tryClass.getSimpleName());
                    outputBuilder.append("; GoodResult: ");
                    outputBuilder.append(pass);
                }
            }
            catch (IllegalAccessException e) {
                Msg.warn((Object)this, (Object)e.getMessage());
                return false;
            }
            catch (InstantiationException e) {
                Msg.warn((Object)this, (Object)e.getMessage());
                return false;
            }
        }
        Msg.info((Object)this, (Object)outputBuilder);
        return true;
    }
}

