/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx.analyzers;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class MachoConstructorDestructorAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Mach-O Constructor/Destructor";
    private static final String DESCRIPTION = "Creates pointers to global constructors and destructors in a Mach-O file.";
    private static final String CONSTRUCTOR = "__constructor";
    private static final String DESTRUCTOR = "__destructor";

    public MachoConstructorDestructorAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        List<MemoryBlock> blocks = this.getBlocks(program);
        block3: for (MemoryBlock block : blocks) {
            Address currentAddress = block.getStart();
            while (!monitor.isCancelled() && currentAddress.compareTo((Object)block.getEnd()) < 0) {
                try {
                    Data data = program.getListing().createData(currentAddress, (DataType)new PointerDataType());
                    currentAddress = currentAddress.add((long)data.getLength());
                }
                catch (CodeUnitInsertionException e) {
                    continue block3;
                }
                catch (DataTypeConflictException e) {
                    continue block3;
                }
            }
        }
        return false;
    }

    public boolean canAnalyze(Program program) {
        return this.checkIfValid(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return this.checkIfValid(program);
    }

    private boolean checkIfValid(Program program) {
        return !this.getBlocks(program).isEmpty();
    }

    private List<MemoryBlock> getBlocks(Program program) {
        ArrayList<MemoryBlock> list = new ArrayList<MemoryBlock>();
        if (program.getExecutableFormat().equals("Mac OS X Mach-O")) {
            MemoryBlock[] blocks;
            for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
                if (block.getName().equals(CONSTRUCTOR)) {
                    list.add(block);
                    continue;
                }
                if (!block.getName().equals(DESTRUCTOR)) continue;
                list.add(block);
            }
        }
        return list;
    }
}

