/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import ghidra.app.util.importer.MessageLog;
import ghidra.file.jad.JarDecompilerTask;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import utilities.util.FileUtilities;

public class JarDecompiler {
    private FSRL jarFile;
    private File outputDirectory;
    private MessageLog log = new MessageLog();

    public static boolean isJarFilename(String filename) {
        return "jar".equalsIgnoreCase(FilenameUtils.getExtension((String)filename));
    }

    public JarDecompiler(FSRL jarFile, File outputDirectory) {
        this.jarFile = jarFile;
        this.outputDirectory = outputDirectory;
    }

    public void decompile(TaskMonitor monitor) throws IOException, CancelledException {
        FileUtilities.checkedMkdirs((File)this.outputDirectory);
        monitor.setMessage("");
        this.unzip(monitor);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("");
        this.processListing(this.outputDirectory, monitor);
        monitor.setMessage("");
    }

    public MessageLog getLog() {
        return this.log;
    }

    private String getRelPath(File directory) {
        return directory.getPath().substring(this.outputDirectory.getPath().length());
    }

    private void processListing(File directory, TaskMonitor monitor) {
        Iterator iterator = FileUtils.iterateFilesAndDirs((File)directory, (IOFileFilter)FalseFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (iterator.hasNext()) {
            File dir = (File)iterator.next();
            JarDecompilerTask task = new JarDecompilerTask(dir, this.jarFile.getName() + ":" + this.getRelPath(dir));
            TaskLauncher.launch((Task)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(TaskMonitor monitor) throws ZipException, IOException, FileNotFoundException, CancelledException {
        File file = FileSystemService.getInstance().getFile(this.jarFile, monitor);
        monitor.initialize((long)this.countZipEntries(zipFile, monitor));
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                if (monitor.isCancelled()) {
                    break;
                }
                ZipEntry zipEntry = entries.nextElement();
                File absoluteFile = new File(this.outputDirectory.getAbsolutePath(), zipEntry.getName());
                if (!FileUtilities.isPathContainedWithin((File)this.outputDirectory, (File)absoluteFile)) {
                    throw new IOException("Extracted file " + absoluteFile.getPath() + " would be outside of root destination directory: " + this.outputDirectory);
                }
                FileUtilities.checkedMkdirs((File)absoluteFile.getParentFile());
                if (zipEntry.isDirectory()) continue;
                monitor.setMessage("Unzipping jar file... ");
                monitor.incrementProgress(1L);
                this.writeFile(zipFile, zipEntry, absoluteFile, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(ZipFile zipFile, ZipEntry zipEntry, File absoluteFile, TaskMonitor monitor) throws IOException {
        byte[] bytes = new byte[0x100000];
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);
             FileOutputStream outputStream = new FileOutputStream(absoluteFile);){
            while (!monitor.isCancelled()) {
                int nRead = inputStream.read(bytes);
                if (nRead == -1) {
                    break;
                }
                ((OutputStream)outputStream).write(bytes, 0, nRead);
            }
        }
    }

    private int countZipEntries(ZipFile zipFile, TaskMonitor monitor) {
        int count = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements() && !monitor.isCancelled()) {
            entries.nextElement();
            ++count;
        }
        return count;
    }
}

