/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ubi;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.CpuTypes;
import ghidra.app.util.bin.format.ubi.FatArch;
import ghidra.app.util.bin.format.ubi.FatHeader;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.program.model.lang.Processor;
import ghidra.util.BoundedInputStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@FileSystemInfo(type="universalbinary", description="Mac OSX Universal Binary", factory=GFileSystemBaseFactory.class)
public class UniversalBinaryFileSystem
extends GFileSystemBase {
    private FatHeader header;
    private List<GFileImpl> list = new ArrayList<GFileImpl>();

    public UniversalBinaryFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        int index = this.list.indexOf(file);
        return index != -1 ? ((FatArch)this.header.getArchitectures().get(index)).toString() : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return new ArrayList<GFileImpl>(this.list);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        boolean isLittleEndian = false;
        BinaryReader reader = new BinaryReader(this.provider, isLittleEndian);
        int magic = reader.readInt(0L);
        int nArch = reader.readInt(4L);
        if (magic == -889275714 || magic == -1095041334) {
            return nArch < 32;
        }
        return false;
    }

    public void open(TaskMonitor monitor) throws IOException, CancelledException {
        try {
            this.header = FatHeader.createFatHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)this.provider);
            List architectures = this.header.getArchitectures();
            for (FatArch architecture : architectures) {
                Processor processor = CpuTypes.getProcessor((int)architecture.getCpuType(), (int)architecture.getCpuSubType());
                int bitSize = CpuTypes.getProcessorBitSize((int)architecture.getCpuType());
                String name = processor + "-" + bitSize + "-cpu0x" + Integer.toHexString(architecture.getCpuSubType());
                GFileImpl file = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)name, (boolean)false, (long)architecture.getSize(), null);
                this.list.add(file);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        int index = this.list.indexOf(file);
        List architectures = this.header.getArchitectures();
        FatArch architecture = (FatArch)architectures.get(index);
        return new BoundedInputStream(this.provider.getInputStream((long)architecture.getOffset()), (long)architecture.getSize());
    }

    public void close() throws IOException {
        super.close();
    }
}

