/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ext4.Ext4FileSystem;
import ghidra.file.formats.ext4.Ext4SuperBlock;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryFull;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class Ext4FileSystemFactory
implements GFileSystemProbeFull,
GFileSystemFactoryFull<Ext4FileSystem> {
    public Ext4FileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        Ext4FileSystem fs = new Ext4FileSystem(targetFSRL, byteProvider);
        fs.mountFS(monitor);
        return fs;
    }

    public boolean probe(FSRL containerFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        try {
            BinaryReader reader = new BinaryReader(byteProvider, true);
            reader.setPointerIndex(1024);
            Ext4SuperBlock superBlock = new Ext4SuperBlock(reader);
            if ((superBlock.getS_magic() & 0xFFFF) == 61267) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

