/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class ImmutableMemoryRangeByteProvider
implements ByteProvider {
    private Memory memory;
    private Address start;
    private Address end;

    ImmutableMemoryRangeByteProvider(Memory memory, Address start, Address end) {
        this.memory = memory;
        this.start = start;
        this.end = end;
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        MemoryBlock block = this.memory.getBlock(this.start);
        if (block != null) {
            return block.getName();
        }
        return this.memory.getProgram().getName() + "_" + this.start.toString();
    }

    public String getAbsolutePath() {
        throw new UnsupportedOperationException();
    }

    public long length() throws IOException {
        return this.end.subtract(this.start) + 1L;
    }

    public boolean isValidIndex(long index) {
        Address indexAddress = this.start.add(index);
        return this.start.compareTo((Object)indexAddress) >= 0 && this.end.compareTo((Object)indexAddress) <= 0;
    }

    public void close() throws IOException {
    }

    public byte readByte(long index) throws IOException {
        Address indexAddress = this.start.add(index);
        try {
            return this.memory.getByte(indexAddress);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public byte[] readBytes(long index, long length) throws IOException {
        try {
            byte[] bytes = new byte[(int)length];
            Address indexAddress = this.start.add(index);
            int nRead = this.memory.getBytes(indexAddress, bytes);
            if ((long)nRead != length) {
                throw new IOException("Unable to read " + length + " bytes at index " + index);
            }
            return bytes;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public InputStream getInputStream(long index) throws IOException {
        throw new UnsupportedOperationException();
    }
}

