/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.odex;

import ghidra.app.util.bin.ByteProvider;

public final class OdexConstants {
    public static final String ODEX_MAGIC_35 = "dey\n035\u0000";
    public static final String ODEX_MAGIC_36 = "dey\n036\u0000";
    public static final String ODEX_MAGIC_37 = "dey\n037\u0000";
    public static final int ODEX_MAGIC_LENGTH = "dey\n036\u0000".length();

    public static final boolean isOdexFile(ByteProvider provider) {
        try {
            byte[] bytes = provider.readBytes(0L, (long)ODEX_MAGIC_LENGTH);
            return ODEX_MAGIC_35.equals(new String(bytes)) || ODEX_MAGIC_36.equals(new String(bytes));
        }
        catch (Exception exception) {
            return false;
        }
    }
}

