/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.dex.format.AnnotationSetReferenceList;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ParameterAnnotation
implements StructConverter {
    private int methodIndex;
    private int annotationsOffset;
    private AnnotationSetReferenceList _annotationSetReferenceList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterAnnotation(BinaryReader reader) throws IOException {
        this.methodIndex = reader.readNextInt();
        this.annotationsOffset = reader.readNextInt();
        if (this.annotationsOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.annotationsOffset);
                this._annotationSetReferenceList = new AnnotationSetReferenceList(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public int getAnnotationsOffset() {
        return this.annotationsOffset;
    }

    public AnnotationSetReferenceList getAnnotationSetReferenceList() {
        return this._annotationSetReferenceList;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(ParameterAnnotation.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

