/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class CodeUnitOffsetSettingsDefinition
implements EnumSettingsDefinition {
    private static final String MEMORY_OFFSET = "Code-unit offset";
    public static final CodeUnitOffsetSettingsDefinition DEF = new CodeUnitOffsetSettingsDefinition();
    public static final int DEFAULT_OFFSET = 0;
    public static final int MIN_OFFSET = -8;
    public static final int MAX_OFFSET = 8;
    public static final int DEFAULT_CHOICE = 8;
    private static final String[] choices = new String[]{"-8", "-7", "-6", "-5", "-4", "-3", "-2", "-1", "0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8"};

    private CodeUnitOffsetSettingsDefinition() {
    }

    public int getOffset(Settings settings) {
        return this.getChoice(settings) - 8;
    }

    public void setOffset(Settings settings, int offset) {
        if (offset < -8) {
            offset = -8;
        }
        if (offset > 8) {
            offset = 8;
        }
        settings.setLong(MEMORY_OFFSET, (long)(offset + 8));
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 8;
        }
        Long value = settings.getLong(MEMORY_OFFSET);
        if (value == null) {
            return 8;
        }
        return value.intValue();
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > choices.length - 1) {
            value = choices.length - 1;
        }
        settings.setLong(MEMORY_OFFSET, (long)value);
    }

    public String getDisplayValue(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return MEMORY_OFFSET;
    }

    public String getDescription() {
        return "Selects the relative byte offset from which to display";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(MEMORY_OFFSET);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(MEMORY_OFFSET);
        if (l == null) {
            destSettings.clearSetting(MEMORY_OFFSET);
        } else {
            destSettings.setLong(MEMORY_OFFSET, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(MEMORY_OFFSET) != null;
    }
}

