/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.support.GTreeRenderer;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBActionManager;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.FileIconService;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.ImageManager;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class FileSystemBrowserComponentProvider
extends ComponentProviderAdapter {
    private static final String TITLE = "Filesystem Viewer";
    private FileSystemBrowserPlugin plugin;
    private FSBActionManager actionManager;
    private GTree gTree;
    private FSBRootNode rootNode;

    public FileSystemBrowserComponentProvider(FileSystemBrowserPlugin plugin, FileSystemRef fsRef) {
        super(plugin.getTool(), fsRef.getFilesystem().getName(), plugin.getName());
        this.plugin = plugin;
        this.rootNode = new FSBRootNode(fsRef);
        this.setTransient();
        this.setIcon(ImageManager.PHOTO);
        this.gTree = new GTree((GTreeRootNode)this.rootNode);
        this.gTree.getSelectionModel().setSelectionMode(4);
        this.gTree.getSelectionModel().addTreeSelectionListener(e -> {
            this.tool.contextChanged((ComponentProvider)this);
            TreePath[] paths = this.gTree.getSelectionPaths();
            if (paths.length == 1) {
                GTreeNode clickedNode = (GTreeNode)paths[0].getLastPathComponent();
                this.handleSingleClick(clickedNode);
            }
        });
        this.gTree.addMouseListener((MouseListener)new MouseAdapter(){
            int prevMouseButton = -1;

            @Override
            public void mouseReleased(MouseEvent e) {
                int localPrevMouseButton = this.prevMouseButton;
                this.prevMouseButton = e.getButton();
                if (e.isPopupTrigger()) {
                    return;
                }
                GTreeNode clickedNode = FileSystemBrowserComponentProvider.this.gTree.getNodeForLocation(e.getX(), e.getY());
                if (e.getClickCount() == 1) {
                    FileSystemBrowserComponentProvider.this.handleSingleClick(clickedNode);
                }
                if (e.getClickCount() == 2 && e.getButton() == 1 && localPrevMouseButton == 1) {
                    FileSystemBrowserComponentProvider.this.handleDoubleClick(clickedNode);
                }
            }
        });
        this.gTree.setCellRenderer(new GTreeRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof FSBRootNode) {
                    this.renderFS((FSBRootNode)value, selected);
                } else if (value instanceof FSBFileNode) {
                    this.renderFile((FSBFileNode)value, selected);
                } else if (value instanceof FSBNode) {
                    this.renderNode((FSBNode)value, selected);
                }
                return this;
            }

            private void renderFS(FSBRootNode node, boolean selected) {
                FileSystemRef nodeFSRef = node.getFSRef();
                if (nodeFSRef == null || nodeFSRef.getFilesystem() == null) {
                    return;
                }
                FSRLRoot fsFSRL = nodeFSRef.getFilesystem().getFSRL();
                String containerFilename = fsFSRL.hasContainer() ? fsFSRL.getContainer().getName() : "unknown";
                Icon image = FileIconService.getInstance().getImage(containerFilename, "filesystem");
                this.setIcon(image);
            }

            private void renderFile(FSBFileNode node, boolean selected) {
                FSRL fsrl = node.getFSRL();
                String filename = fsrl.getName();
                Icon ico = FileIconService.getInstance().getImage(filename, ProgramMappingService.isFileImportedIntoProject(fsrl) ? "imported" : null, FileSystemService.getInstance().isFilesystemMountedAt(fsrl) ? "filesystem" : null);
                this.setIcon(ico);
                if (ProgramMappingService.isFileOpen(fsrl)) {
                    this.setForeground(selected ? Color.CYAN : Color.MAGENTA);
                }
            }

            private void renderNode(FSBNode node, boolean selected) {
            }
        });
        this.actionManager = new FSBActionManager(plugin, this, (TextEditorService)plugin.getTool().getService(TextEditorService.class), this.gTree);
        this.setHelpLocation(new HelpLocation("FileSystemBrowserPlugin", "FileSystemBrowserIntroduction"));
    }

    GTree getGTree() {
        return this.gTree;
    }

    FSBActionManager getActionManager() {
        return this.actionManager;
    }

    public void componentHidden() {
        if (this.plugin != null && this.rootNode.getFSRef() != null && this.rootNode.getFSRef().getFilesystem() != null) {
            this.plugin.removeFileSystemBrowser(this.rootNode.getFSRef().getFilesystem().getFSRL());
        }
    }

    public void afterAddedToTool() {
        this.actionManager.registerComponentActionsInTool();
    }

    private boolean quickShowProgram(FSRL fsrl) {
        Object consumer;
        Program program;
        ProgramManager programManager;
        if (this.plugin.hasProgramManager() && (programManager = FSBUtils.getProgramManager(this.plugin.getTool(), false)) != null && (program = ProgramMappingService.findMatchingOpenProgram(fsrl, consumer = new Object())) != null) {
            programManager.setCurrentProgram(program);
            program.release(consumer);
            return true;
        }
        return false;
    }

    private void handleSingleClick(GTreeNode clickedNode) {
        FSBFileNode node;
        if (clickedNode instanceof FSBFileNode && (node = (FSBFileNode)clickedNode).getFSRL() != null) {
            this.quickShowProgram(node.getFSRL());
        }
    }

    private void handleDoubleClick(GTreeNode clickedNode) {
        FSBFileNode node;
        if (clickedNode instanceof FSBFileNode && (node = (FSBFileNode)clickedNode).getFSRL() != null && !this.quickShowProgram(node.getFSRL())) {
            this.actionManager.actionOpenPrograms.actionPerformed(this.getActionContext(null));
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        TreePath[] selectionPaths = this.gTree.getSelectionPaths();
        if (selectionPaths != null && selectionPaths.length == 1) {
            Object lastPathComponent = selectionPaths[0].getLastPathComponent();
            return new FSBActionContext((ComponentProvider)this, lastPathComponent, this.gTree);
        }
        if (selectionPaths != null && selectionPaths.length > 0) {
            ArrayList<FSBNode> list = new ArrayList<FSBNode>();
            for (TreePath selectionPath : selectionPaths) {
                Object lastPathComponent = selectionPath.getLastPathComponent();
                if (!(lastPathComponent instanceof FSBNode)) continue;
                FSBNode node = (FSBNode)lastPathComponent;
                list.add(node);
            }
            if (list.size() == 1) {
                return new FSBActionContext((ComponentProvider)this, list.get(0), this.gTree);
            }
            FSBNode[] nodes = new FSBNode[list.size()];
            list.toArray(nodes);
            return new FSBActionContext((ComponentProvider)this, nodes, this.gTree);
        }
        if (event != null) {
            JTree sourceTree;
            Object source = event.getSource();
            int x = event.getX();
            int y = event.getY();
            if (source instanceof JTree && this.gTree.isMyJTree(sourceTree = (JTree)source)) {
                return new FSBActionContext((ComponentProvider)this, this.gTree.getNodeForLocation(x, y), this.gTree);
            }
        }
        return null;
    }

    public JComponent getComponent() {
        return this.gTree;
    }

    public String getName() {
        return TITLE;
    }

    public WindowPosition getDefaultWindowPosition() {
        return WindowPosition.WINDOW;
    }

    void dispose() {
        if (this.actionManager != null) {
            this.actionManager.dispose();
            this.actionManager = null;
        }
        if (this.gTree != null) {
            this.gTree.dispose();
            this.gTree = null;
        }
        this.plugin = null;
    }
}

