/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalysisRecipe;
import ghidra.framework.analysis.GhidraScriptAnalyzerAdapter;
import org.jdom.Element;

class AnalyzerInfo
implements Comparable<AnalyzerInfo> {
    static final String XML_ELEMENT_NAME = "ANALYZER";
    static final String CLASS_NAME = "CLASS_NAME";
    private boolean enabled;
    private final boolean defaultEnablement;
    private Analyzer analyzer;
    private AnalysisPriority analysisPriority;
    private AnalysisPhase startPhase;
    private AnalysisRecipe recipe;

    AnalyzerInfo(AnalysisRecipe analysisRecipe, Analyzer analyzer, boolean defaultEnablement) {
        this.recipe = analysisRecipe;
        this.analyzer = analyzer;
        this.startPhase = this.recipe.getLastPhase();
        this.analysisPriority = analyzer.getPriority();
        this.defaultEnablement = defaultEnablement;
        this.enabled = defaultEnablement;
    }

    @Override
    public int compareTo(AnalyzerInfo o) {
        AnalyzerType myType = this.analyzer.getAnalysisType();
        AnalyzerType otherType = o.analyzer.getAnalysisType();
        if (myType == AnalyzerType.ONE_SHOT_ANALYZER && otherType != AnalyzerType.ONE_SHOT_ANALYZER) {
            return -1;
        }
        if (myType != AnalyzerType.ONE_SHOT_ANALYZER && otherType == AnalyzerType.ONE_SHOT_ANALYZER) {
            return 1;
        }
        int diff = this.analysisPriority.priority() - o.analysisPriority.priority();
        if (diff == 0) {
            return this.analyzer.getName().compareTo(o.analyzer.getName());
        }
        return diff;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public AnalysisPhase getNextEnabledPhaseAtOrAfter(AnalysisPhase phase) {
        if (!this.enabled) {
            return null;
        }
        if (phase.compareTo(this.startPhase) <= 0) {
            return this.startPhase;
        }
        if (this.analyzer.getAnalysisType() == AnalyzerType.ONE_SHOT_ANALYZER) {
            return null;
        }
        return phase;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setStartPhase(AnalysisPhase phase) {
        this.startPhase = phase;
    }

    Element toXML() {
        Element element = new Element(XML_ELEMENT_NAME);
        element.setAttribute(CLASS_NAME, this.analyzer.getClass().getName());
        if (this.analyzer instanceof GhidraScriptAnalyzerAdapter) {
            GhidraScriptAnalyzerAdapter wrappedAnalyzer = (GhidraScriptAnalyzerAdapter)this.analyzer;
            element.setAttribute("SCRIPT_NAME", wrappedAnalyzer.getScriptName());
            element.setAttribute("ANALYZER_TYPE", wrappedAnalyzer.getAnalysisType().name());
            element.setAttribute("PRIORITY", Integer.toString(wrappedAnalyzer.getPriority().priority()));
        }
        element.setAttribute("START_PHASE", Integer.toString(this.startPhase.getIndex()));
        if (this.enabled != this.defaultEnablement) {
            element.setAttribute("ENABLED", Boolean.toString(this.enabled));
        }
        return element;
    }

    void loadFromXML(Element element) {
        String enabledValue = element.getAttributeValue("ENABLED");
        if (enabledValue != null) {
            this.enabled = Boolean.parseBoolean(enabledValue);
        }
        int startPhaseIndex = Integer.parseInt(element.getAttributeValue("START_PHASE"));
        this.startPhase = this.recipe.getPhase(startPhaseIndex);
    }

    public AnalysisPhase getAnalyzerStartPhase() {
        return this.startPhase;
    }

    public static AnalyzerInfo createInfoForWrappedAnalzyer(AnalysisRecipe recipe, Element element) {
        String scriptName = element.getAttributeValue("SCRIPT_NAME");
        String type = element.getAttributeValue("ANALYZER_TYPE");
        AnalyzerType analyzerType = AnalyzerType.valueOf(type);
        int priority = Integer.parseInt(element.getAttributeValue("PRIORITY"));
        ScriptInfo scriptInfo = GhidraScriptUtil.findScriptByName(scriptName);
        ResourceFile file = scriptInfo.getSourceFile();
        GhidraScriptAnalyzerAdapter analyzer = new GhidraScriptAnalyzerAdapter(file, analyzerType, priority);
        return new AnalyzerInfo(recipe, analyzer, true);
    }
}

