/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.datatype.microsoft.RTTI0DataType;
import ghidra.app.util.datatype.microsoft.RTTI3DataType;
import ghidra.app.util.datatype.microsoft.RTTIDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;

@Deprecated
public class RTTI4DataType
extends RTTIDataType {
    private static final long serialVersionUID = 1L;
    private static final int LENGTH = 20;
    private static final int SIGNATURE_OFFSET = 0;
    private static final int VB_TABLE_OFFSET_OFFSET = 4;
    private static final int CONSTRUCTOR_DISP_OFFSET_OFFSET = 8;
    private static final int RTTI_0_OFFSET = 12;
    private static final int RTTI_3_OFFSET = 16;
    private DataTypeComponent[] fixedComps;
    private RTTI0DataType rtti0;
    private RTTI3DataType rtti3;

    public RTTI4DataType() {
        this(null);
    }

    public RTTI4DataType(DataTypeManager dtm) {
        super("RTTI_4", dtm);
        this.buildFixedComponents();
        this.rtti0 = new RTTI0DataType(dtm);
        this.rtti3 = new RTTI3DataType(dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RTTI4DataType(dtm);
    }

    private void buildFixedComponents() {
        this.fixedComps = new DataTypeComponent[3];
        this.fixedComps[0] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 0, 0, "signature", null);
        this.fixedComps[1] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 1, 4, "offset", "offset of vbtable within class");
        this.fixedComps[2] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 2, 8, "cdOffset", "constructor displacement offset");
    }

    public String getDescription() {
        return "RTTI 4 (RTTI Complete Object Locator) Structure";
    }

    public String getMnemonic(Settings settings) {
        return "RTTI_4";
    }

    public int getLength() {
        return 20;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Program program = buf.getMemory().getProgram();
        DataTypeManager dtm = program.getDataTypeManager();
        RTTI0DataType rtti0Dt = new RTTI0DataType(dtm);
        RTTI3DataType rtti3Dt = new RTTI3DataType(dtm);
        DataType rtti0RefDt = MSDataTypeUtils.getReferenceDataType(program, (DataType)rtti0Dt);
        DataType rtti3RefDt = MSDataTypeUtils.getReferenceDataType(program, (DataType)rtti3Dt);
        DataTypeComponent[] comps = new DataTypeComponent[5];
        System.arraycopy(this.fixedComps, 0, comps, 0, 3);
        comps[3] = new ReadOnlyDataTypeComponent(rtti0RefDt, (DynamicDataType)this, 4, 3, 12, "pTypeDescriptor", MSDataTypeUtils.is64Bit(program) ? "rtti0Displacement" : "rtti0Pointer");
        comps[4] = new ReadOnlyDataTypeComponent(rtti3RefDt, (DynamicDataType)this, 4, 4, 16, "pClassDescriptor", MSDataTypeUtils.is64Bit(program) ? "rtti3Displacement" : "rtti3Pointer");
        return comps;
    }

    public int getLength(Memory memory, Address address, byte[] bytes) {
        Program program = memory.getProgram();
        if (address.getOffset() % 4L != 0L) {
            return 0;
        }
        if (bytes.length < 20) {
            return 0;
        }
        Address rtti0CompAddress = address.add(12L);
        Address rtti0Address = MSDataTypeUtils.getReferencedAddress(program, rtti0CompAddress);
        if (rtti0Address == null || !memory.contains(rtti0Address)) {
            return 0;
        }
        Address rtti3CompAddress = address.add(16L);
        Address rtti3Address = MSDataTypeUtils.getReferencedAddress(program, rtti3CompAddress);
        if (rtti3Address == null || !memory.contains(rtti3Address)) {
            return 0;
        }
        return 20;
    }

    public Address getRtti0Address(Memory memory, Address rtti4Address) {
        Program program = memory.getProgram();
        Address rtti0CompAddress = rtti4Address.add(12L);
        return MSDataTypeUtils.getReferencedAddress(program, rtti0CompAddress);
    }

    public Address getRtti3Address(Memory memory, Address rtti4Address) {
        Program program = memory.getProgram();
        Address rtti3CompAddress = rtti4Address.add(16L);
        return MSDataTypeUtils.getReferencedAddress(program, rtti3CompAddress);
    }

    @Override
    public boolean isValid(Program program, Address startAddress, DataValidationOptions validationOptions) {
        Memory memory = program.getMemory();
        if (!memory.contains(startAddress)) {
            return false;
        }
        if (startAddress.getOffset() % 4L != 0L) {
            return false;
        }
        Listing listing = program.getListing();
        Address endAddress = startAddress.add(19L);
        try {
            MSDataTypeUtils.getBytes(memory, startAddress, 20);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (!validationOptions.shouldIgnoreInstructions() && this.containsInstruction(listing, startAddress, endAddress)) {
            return false;
        }
        if (!validationOptions.shouldIgnoreDefinedData() && this.containsDefinedData(listing, startAddress, endAddress)) {
            return false;
        }
        boolean validateReferredToData = validationOptions.shouldValidateReferredToData();
        Address rtti0CompAddress = startAddress.add(12L);
        Address rtti0Address = MSDataTypeUtils.getReferencedAddress(program, rtti0CompAddress);
        if (rtti0Address == null || validateReferredToData && !this.rtti0.isValid(program, rtti0Address, validationOptions)) {
            return false;
        }
        Address rtti3CompAddress = startAddress.add(16L);
        Address rtti3Address = MSDataTypeUtils.getReferencedAddress(program, rtti3CompAddress);
        return rtti3Address != null && (!validateReferredToData || this.rtti3.isValid(program, rtti3Address, validationOptions));
    }

    public String getDefaultLabelPrefix() {
        return "RTTI_4";
    }
}

