/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.datatype.microsoft.RTTI1DataType;
import ghidra.app.util.datatype.microsoft.RTTIDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import java.util.ArrayList;

@Deprecated
public class RTTI2DataType
extends RTTIDataType {
    private static final int ENTRY_SIZE = 4;
    private static final long serialVersionUID = 1L;
    private RTTI1DataType rtti1;
    private long rtti1Count;

    public RTTI2DataType() {
        this(null);
    }

    public RTTI2DataType(long rtti1Count) {
        this(rtti1Count, null);
    }

    public RTTI2DataType(DataTypeManager dtm) {
        super("RTTI_2", dtm);
        this.rtti1 = new RTTI1DataType(dtm);
    }

    public RTTI2DataType(long rtti1Count, DataTypeManager dtm) {
        super("RTTI_2", dtm);
        this.rtti1Count = rtti1Count;
        this.rtti1 = new RTTI1DataType(dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RTTI2DataType(this.rtti1Count, dtm);
    }

    public String getDescription() {
        return "RTTI 2 (RTTI Base Class Array) Structure.";
    }

    public String getMnemonic(Settings settings) {
        return "RTTI_2";
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    private boolean validRefData(Memory memory, Address addr) {
        Settings settings;
        DumbMemBufferImpl refBuffer;
        Program program = memory.getProgram();
        boolean is64Bit = MSDataTypeUtils.is64Bit(program);
        DataType refDt = MSDataTypeUtils.getReferenceDataType(program, null);
        Object value = refDt.getValue((MemBuffer)(refBuffer = new DumbMemBufferImpl(memory, addr)), settings = MSDataTypeUtils.getReferenceDataType(program, null).getDefaultSettings(), 4);
        if (value instanceof Address) {
            Address address = (Address)value;
            if (is64Bit && program.getImageBase().equals((Object)address)) {
                return false;
            }
            if (!is64Bit && address.getOffset() == 0L) {
                return false;
            }
            return memory.getLoadedAndInitializedAddressSet().contains(address);
        }
        return false;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        ArrayList<ReadOnlyDataTypeComponent> list = new ArrayList<ReadOnlyDataTypeComponent>();
        Memory memory = buf.getMemory();
        Address addr = buf.getAddress();
        Program program = memory.getProgram();
        DataTypeManager dtm = program.getDataTypeManager();
        RTTI1DataType rtti1Dt = new RTTI1DataType(dtm);
        boolean is64Bit = MSDataTypeUtils.is64Bit(program);
        DataType rtti1RefDt = MSDataTypeUtils.getReferenceDataType(program, (DataType)rtti1Dt);
        int ordinal = 0;
        while (addr != null && this.validRefData(memory, addr)) {
            ReadOnlyDataTypeComponent comp = new ReadOnlyDataTypeComponent(rtti1RefDt, (DynamicDataType)this, 4, ordinal, ordinal * 4, null, is64Bit ? "rtti1Displacement" : "rtti1Pointer");
            list.add(comp);
            addr = addr.add(4L);
            ++ordinal;
        }
        return list.toArray(new DataTypeComponent[list.size()]);
    }

    public int getLength(Memory memory, Address address, byte[] bytes) {
        if (address.getOffset() % 4L != 0L) {
            return 0;
        }
        int length = 0;
        for (Address currentAddress = address; length + 4 < bytes.length && currentAddress != null && this.validRefData(memory, currentAddress); currentAddress = currentAddress.add(4L)) {
        }
        return length;
    }

    public Address getRtti1Address(Memory memory, Address rtti2Address, int rtti1Index) {
        return this.getRtti1Address(memory.getProgram(), rtti2Address, rtti1Index);
    }

    public Address getRtti1Address(Program program, Address rtti2Address, int rtti1Index) {
        Address rtti1Address = rtti2Address.add((long)(rtti1Index * 4));
        return MSDataTypeUtils.getReferencedAddress(program, rtti1Address);
    }

    public boolean isValidRtti1Pointer(Program program, Address startAddress, int pointerIndex, boolean overwriteInstructions, boolean overwriteDefinedData) {
        return this.isValidRtti1Pointer(program, startAddress, pointerIndex, this.convertValidationOptions(overwriteInstructions, overwriteDefinedData));
    }

    public boolean isValidRtti1Pointer(Program program, Address startAddress, int pointerIndex, DataValidationOptions validationOptions) {
        Address pointerAddress = startAddress.add((long)(4 * pointerIndex));
        return this.isValid(program, pointerAddress, validationOptions);
    }

    @Override
    public boolean isValid(Program program, Address startAddress, DataValidationOptions validationOptions) {
        long numEntries;
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        if (!memory.contains(startAddress)) {
            return false;
        }
        long l = numEntries = this.rtti1Count != 0L ? this.rtti1Count : this.getNumEntries(program, startAddress, validationOptions);
        if (numEntries == 0L) {
            return false;
        }
        long length = numEntries * 4L;
        Address endAddress = startAddress.add(length - 1L);
        if (!this.validRefData(memory, startAddress)) {
            return false;
        }
        if (!validationOptions.shouldIgnoreInstructions() && this.containsInstruction(listing, startAddress, endAddress)) {
            return false;
        }
        if (!validationOptions.shouldIgnoreDefinedData() && this.containsDefinedData(listing, startAddress, endAddress)) {
            return false;
        }
        boolean validateReferredToData = validationOptions.shouldValidateReferredToData();
        Address addr = startAddress;
        int ordinal = 0;
        while ((long)ordinal < numEntries && addr != null && this.validRefData(memory, addr)) {
            Address rtti1Address = MSDataTypeUtils.getReferencedAddress(program, addr);
            if (rtti1Address == null || validateReferredToData && !this.rtti1.isValid(program, rtti1Address, validationOptions)) {
                return false;
            }
            try {
                addr = addr.add(4L);
            }
            catch (AddressOutOfBoundsException e) {
                if ((long)ordinal >= this.rtti1Count - 1L) break;
                return false;
            }
            ++ordinal;
        }
        return true;
    }

    private long getNumEntries(Program program, Address startAddress, DataValidationOptions validationOptions) {
        Memory memory = program.getMemory();
        Address addr = startAddress;
        int ordinal = 0;
        while (addr != null && this.validRefData(memory, addr)) {
            Address rtti1Address = MSDataTypeUtils.getReferencedAddress(program, addr);
            if (rtti1Address == null || !this.rtti1.isValid(program, rtti1Address, validationOptions)) {
                return ordinal;
            }
            try {
                addr = addr.add(4L);
            }
            catch (AddressOutOfBoundsException e) {
                return ordinal + 1;
            }
            ++ordinal;
        }
        return ordinal;
    }

    public String getDefaultLabelPrefix() {
        return "RTTI_2";
    }
}

