/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.DataSym32;
import ghidra.app.util.bin.format.pe.debug.DataSym32_new;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.app.util.bin.format.pe.debug.S_ALIGN;
import ghidra.app.util.bin.format.pe.debug.S_BLOCK32;
import ghidra.app.util.bin.format.pe.debug.S_BPREL32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_COMPILE;
import ghidra.app.util.bin.format.pe.debug.S_CONSTANT32;
import ghidra.app.util.bin.format.pe.debug.S_DATAREF;
import ghidra.app.util.bin.format.pe.debug.S_END;
import ghidra.app.util.bin.format.pe.debug.S_GDATA32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_GPROC32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_LABEL32;
import ghidra.app.util.bin.format.pe.debug.S_LDATA32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_OBJNAME;
import ghidra.app.util.bin.format.pe.debug.S_PROCREF;
import ghidra.app.util.bin.format.pe.debug.S_UDT32_NEW;
import ghidra.app.util.bin.format.pe.debug.UnknownSymbol;
import java.io.IOException;

public class DebugSymbolSelector {
    public static DebugSymbol selectSymbol(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        short length = reader.readShort(ptr);
        short type = reader.readShort(ptr += 2);
        ptr += 2;
        if (length == 0 || type < 0) {
            return null;
        }
        switch (type) {
            case 513: 
            case 514: 
            case 515: {
                return DataSym32.createDataSym32(length, type, reader, ptr);
            }
            case 4105: {
                return DataSym32_new.createDataSym32_new(length, type, reader, ptr);
            }
            case 1024: 
            case 1027: {
                return S_PROCREF.createS_PROCREF(length, type, reader, ptr);
            }
            case 1025: {
                return S_DATAREF.createS_DATAREF(length, type, reader, ptr);
            }
            case 1026: {
                return S_ALIGN.createS_ALIGN(length, type, reader, ptr);
            }
            case 4099: {
                return S_UDT32_NEW.createS_UDT32_NEW(length, type, reader, ptr);
            }
            case 4103: {
                return S_LDATA32_NEW.createS_LDATA32_NEW(length, type, reader, ptr);
            }
            case 4106: 
            case 4107: {
                return S_GPROC32_NEW.createS_GPROC32_NEW(length, type, reader, ptr);
            }
            case 4102: {
                return S_BPREL32_NEW.createS_BPREL32_NEW(length, type, reader, ptr);
            }
            case 6: {
                return S_END.createS_END(length, type, reader, ptr);
            }
            case 519: {
                return S_BLOCK32.createS_BLOCK32(length, type);
            }
            case 1: {
                return S_COMPILE.createS_COMPILE(length, type);
            }
            case 9: {
                return S_OBJNAME.createS_OBJNAME(length, type, reader, ptr);
            }
            case 4098: {
                return S_CONSTANT32.createS_CONSTANT32(length, type, reader, ptr);
            }
            case 4104: {
                return S_GDATA32_NEW.createS_GDATA32_NEW(length, type, reader, ptr);
            }
            case 521: {
                return S_LABEL32.createS_LABEL32(length, type, reader, ptr);
            }
        }
        return UnknownSymbol.createUnknownSymbol(length, type, reader, ptr);
    }
}

