/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.methods;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CliMethodExtraSections
implements StructConverter {
    public static final String PATH = "/PE/CLI/Methods/ExtraSections";
    private List<ExtraSection> extraSections = new ArrayList<ExtraSection>();

    public CliMethodExtraSections(BinaryReader reader) throws IOException {
        ExtraSection section;
        do {
            section = new ExtraSection(reader);
            this.extraSections.add(section);
        } while (section.hasMoreSections);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath(PATH), "ExtraSections", 0);
        for (ExtraSection section : this.extraSections) {
            struct.add(section.toDataType(), "ExtraSection", null);
        }
        return struct;
    }

    private class ExtraSection {
        public boolean isEHTable;
        public boolean isFat;
        public boolean hasMoreSections;
        public int dataSize;
        public boolean isFilterBasedException;
        public static final int CorILMethod_Sect_EHTable = 1;
        public static final int CorILMethod_Sect_OptIL = 2;
        public static final int CorILMethod_Sect_FatFormat = 64;
        public static final int CorILMethod_Sect_MoreSects = 128;
        public static final short COR_ILEXCEPTION_CLAUSE_EXCEPTION = 0;
        public static final short COR_ILEXCEPTION_CLAUSE_FILTER = 1;
        public static final short COR_ILEXCEPTION_CLAUSE_FINALLY = 2;
        public static final short COR_ILEXCEPTION_CLAUSE_FAULT = 4;

        public ExtraSection(BinaryReader reader) throws IOException {
            int flags;
            byte one = reader.readNextByte();
            if ((one & 1) == 1) {
                this.isEHTable = true;
            }
            if ((one & 0x40) == 64) {
                this.isFat = true;
            }
            if ((one & 0x80) == 128) {
                this.hasMoreSections = true;
            }
            if (this.isFat) {
                byte sizeOne = reader.readNextByte();
                short sizeTwoThree = reader.readNextShort();
                this.dataSize = (sizeTwoThree << 8) + (sizeOne & 0xFF);
            } else {
                this.dataSize = reader.readNextByte();
            }
            this.isFilterBasedException = this.isFat ? ((flags = reader.readNextInt()) & 1) == 1 : ((flags = (int)reader.readNextShort()) & 1) == 1;
        }

        public StructureDataType getSmallExceptionClauseDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath(CliMethodExtraSections.PATH), "SmallExceptionHandlerClause", 0);
            struct.add(StructConverter.WORD, "Flags", "COR_ILEXCEPTION_CLAUSE_*");
            struct.add(StructConverter.WORD, "TryOffset", "Offset in bytes of try block from start of header");
            struct.add(StructConverter.BYTE, "TryLength", "Length in bytes of try block");
            struct.add(StructConverter.WORD, "HandlerOffset", "Location of handler for this try block");
            struct.add(StructConverter.BYTE, "HandlerLength", "Size of handler code in bytes");
            if (this.isFilterBasedException) {
                struct.add(StructConverter.DWORD, "FilterOffset", "Offset in method body for filter-based exception handler");
            } else {
                struct.add(StructConverter.DWORD, "ClassToken", "Metadata token for type-based exception handler");
            }
            return struct;
        }

        public StructureDataType getFatExceptionClauseDataType() {
            StructureDataType struct = new StructureDataType(new CategoryPath(CliMethodExtraSections.PATH), "FatExceptionHandlerClause", 0);
            struct.add(StructConverter.DWORD, "Flags", "COR_ILEXCEPTION_CLAUSE_*");
            struct.add(StructConverter.DWORD, "TryOffset", "Offset in bytes of try block from start of header");
            struct.add(StructConverter.DWORD, "TryLength", "Length in bytes of try block");
            struct.add(StructConverter.DWORD, "HandlerOffset", "Location of handler for this try block");
            struct.add(StructConverter.DWORD, "HandlerLength", "Size of handler code in bytes");
            if (this.isFilterBasedException) {
                struct.add(StructConverter.DWORD, "FilterOffset", "Offset in method body for filter-based exception handler");
            } else {
                struct.add(StructConverter.DWORD, "ClassToken", "Metadata token for type-based exception handler");
            }
            return struct;
        }

        public DataType toDataType() {
            int clauseSize = this.isFat ? 24 : 12;
            int numberClauses = (this.dataSize - 4) / clauseSize;
            StructureDataType struct = new StructureDataType(new CategoryPath(CliMethodExtraSections.PATH), "ExtraSection", 0);
            struct.add(StructConverter.BYTE, "Kind", "flags: EH, OptIL, FatFormat, MoreSects");
            if (this.isFat) {
                struct.add(StructConverter.BYTE, "size byte 1", "first byte");
                struct.add(StructConverter.WORD, "size bytes 2-3", "size continued. n*24+4 clauses follow.");
                struct.add((DataType)new ArrayDataType((DataType)this.getFatExceptionClauseDataType(), numberClauses, clauseSize), "Clauses", null);
            } else {
                struct.add(StructConverter.BYTE, "DataSize", "section size inc. header; n*12+4 clauses follow");
                struct.add(StructConverter.WORD, "Padding", "always 0");
                struct.add((DataType)new ArrayDataType((DataType)this.getSmallExceptionClauseDataType(), numberClauses, clauseSize), "Clauses", null);
            }
            return struct;
        }
    }
}

