/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.ControlFlowGuard;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.LoadConfigDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.ImageBaseOffset32DataType;
import ghidra.program.model.data.ImageBaseOffset64DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LoadConfigDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG";
    private LoadConfigDirectory lcd;

    static LoadConfigDataDirectory createLoadConfigDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        LoadConfigDataDirectory loadConfigDataDirectory = (LoadConfigDataDirectory)reader.getFactory().create(LoadConfigDataDirectory.class, new Object[0]);
        loadConfigDataDirectory.initLoadConfigDataDirectory(ntHeader, reader);
        return loadConfigDataDirectory;
    }

    private void initLoadConfigDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    public LoadConfigDirectory getLoadConfigDirectory() {
        return this.lcd;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, DataTypeConflictException, IOException {
        monitor.setMessage(program.getName() + ": load config directory...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        PeUtils.createData(program, addr, this.lcd.toDataType(), log);
        this.markupSeHandler(program, isBinary, monitor, log, ntHeader);
        ControlFlowGuard.markup(this.lcd, program, log, ntHeader);
    }

    private void markupSeHandler(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) {
        long exceptionCount = this.lcd.getSeHandlerCount();
        long exceptionTable = this.lcd.getSeHandlerTable() - ntHeader.getOptionalHeader().getImageBase();
        if (exceptionCount > 65536L) {
            return;
        }
        Address addr = program.getAddressFactory().getDefaultAddressSpace().getAddress(this.va(exceptionTable, isBinary));
        this.setPlateComment(program, addr, "SEHandlerTable (0x" + Long.toHexString(exceptionCount) + " entries)");
        for (int i = 0; i < (int)exceptionCount; ++i) {
            if (monitor.isCancelled()) {
                return;
            }
            ImageBaseOffset64DataType dt = ntHeader.getOptionalHeader().is64bit() ? new ImageBaseOffset64DataType() : new ImageBaseOffset32DataType();
            PeUtils.createData(program, addr, (DataType)dt, log);
            addr = addr.add((long)dt.getLength());
        }
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        this.lcd = LoadConfigDirectory.createLoadConfigDirectory(this.reader, ptr, this.ntHeader.getOptionalHeader());
        return true;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        return this.lcd.toDataType();
    }
}

