/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.pe.LoadConfigDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ImageBaseOffset32DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;

public class ControlFlowGuard {
    public static void markup(LoadConfigDirectory lcd, Program program, MessageLog log, NTHeader ntHeader) {
        boolean is64bit = ntHeader.getOptionalHeader().is64bit();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Memory mem = program.getMemory();
        SymbolTable symbolTable = program.getSymbolTable();
        ControlFlowGuard.markupCfgCheckFunction(lcd, is64bit, space, mem, symbolTable);
        ControlFlowGuard.markupCfgDispatchFunction(lcd, is64bit, space, mem, symbolTable);
        ControlFlowGuard.markupCfgFunctionTable(lcd, program, log);
        ControlFlowGuard.markupRfgFailureRoutine(lcd, space, symbolTable);
        ControlFlowGuard.markupRfgDefaultFailureRoutine(lcd, is64bit, space, mem, symbolTable);
        ControlFlowGuard.markupRfgDefaultStackPointerFunction(lcd, is64bit, space, mem, symbolTable);
    }

    private static void markupCfgCheckFunction(LoadConfigDirectory lcd, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getCfgCheckFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getCfgCheckFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_check_icall", SourceType.IMPORTED);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard check function.", (Throwable)e);
        }
    }

    private static void markupCfgDispatchFunction(LoadConfigDirectory lcd, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getCfgDispatchFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getCfgDispatchFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_dispatch_icall", SourceType.IMPORTED);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard dispatch function.", (Throwable)e);
        }
    }

    private static void markupCfgFunctionTable(LoadConfigDirectory lcd, Program program, MessageLog log) {
        int IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK = -268435456;
        int IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_SHIFT = 28;
        long tablePointer = lcd.getCfgFunctionTablePointer();
        long functionCount = lcd.getCfgFunctionCount();
        if (tablePointer == 0L || functionCount <= 0L) {
            return;
        }
        try {
            Data d;
            Address tableAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(tablePointer);
            program.getSymbolTable().createLabel(tableAddr, "GuardCFFunctionTable", SourceType.IMPORTED);
            LoadConfigDirectory.GuardFlags guardFlags = lcd.getCfgGuardFlags();
            int n = (guardFlags.getFlags() & 0xF0000000) >> 28;
            ImageBaseOffset32DataType ibo32 = new ImageBaseOffset32DataType();
            for (long i = 0L; i < functionCount && (d = PeUtils.createData(program, tableAddr.add(i * (long)(ibo32.getLength() + n)), (DataType)ibo32, log)) != null; ++i) {
            }
        }
        catch (AddressOutOfBoundsException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ControlFlowGuard function table.", (Throwable)e);
        }
    }

    private static void markupRfgFailureRoutine(LoadConfigDirectory lcd, AddressSpace space, SymbolTable symbolTable) {
        if (lcd.getRfgFailureRoutine() == 0L) {
            return;
        }
        try {
            Address routineAddr = space.getAddress(lcd.getRfgFailureRoutine());
            symbolTable.createLabel(routineAddr, "_guard_ss_verify_failure", SourceType.IMPORTED);
        }
        catch (AddressOutOfBoundsException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ReturnFlowGuard failure routine.", (Throwable)e);
        }
    }

    private static void markupRfgDefaultFailureRoutine(LoadConfigDirectory lcd, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getRfgFailureRoutineFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getRfgFailureRoutineFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_ss_verify_failure_default", SourceType.IMPORTED);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ReturnFlowGuard default failure routine.", (Throwable)e);
        }
    }

    private static void markupRfgDefaultStackPointerFunction(LoadConfigDirectory lcd, boolean is64bit, AddressSpace space, Memory mem, SymbolTable symbolTable) {
        if (lcd.getRfgVerifyStackPointerFunctionPointer() == 0L) {
            return;
        }
        try {
            Address functionPointerAddr = space.getAddress(lcd.getRfgVerifyStackPointerFunctionPointer());
            Address functionAddr = space.getAddress(is64bit ? mem.getLong(functionPointerAddr) : (long)mem.getInt(functionPointerAddr));
            symbolTable.createLabel(functionAddr, "_guard_ss_verify_sp_default", SourceType.IMPORTED);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | InvalidInputException e) {
            Msg.warn(ControlFlowGuard.class, (Object)"Unable to label ReturnFlowGuard verify stack pointer function.", (Throwable)e);
        }
    }
}

