/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.elf.ElfFileSection;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfStringTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class ElfSymbolTable
implements ElfFileSection,
ByteArrayConverter {
    private ElfStringTable stringTable;
    private ElfSectionHeader symbolTableSection;
    private long fileOffset;
    private long addrOffset;
    private long length;
    private long entrySize;
    private int symbolCount;
    private boolean is32bit;
    private boolean isDynamic;
    private ElfSymbol[] symbols;

    static ElfSymbolTable createElfSymbolTable(FactoryBundledWithBinaryReader reader, ElfHeader header, ElfSectionHeader symbolTableSection, long fileOffset, long addrOffset, long length, long entrySize, ElfStringTable stringTable, boolean isDynamic) throws IOException {
        ElfSymbolTable elfSymbolTable = (ElfSymbolTable)reader.getFactory().create(ElfSymbolTable.class, new Object[0]);
        elfSymbolTable.initElfSymbolTable(reader, header, symbolTableSection, fileOffset, addrOffset, length, entrySize, stringTable, isDynamic);
        return elfSymbolTable;
    }

    private void initElfSymbolTable(FactoryBundledWithBinaryReader reader, ElfHeader header, ElfSectionHeader symbolTableSection, long fileOffset, long addrOffset, long length, long entrySize, ElfStringTable stringTable, boolean isDynamic) throws IOException {
        this.symbolTableSection = symbolTableSection;
        this.fileOffset = fileOffset;
        this.addrOffset = addrOffset;
        this.length = length;
        this.entrySize = entrySize;
        this.stringTable = stringTable;
        this.is32bit = header.is32Bit();
        this.isDynamic = isDynamic;
        long ptr = reader.getPointerIndex();
        reader.setPointerIndex(fileOffset);
        ArrayList<ElfSymbol> symbolList = new ArrayList<ElfSymbol>();
        this.symbolCount = (int)(length / entrySize);
        long entryPos = reader.getPointerIndex();
        for (int i = 0; i < this.symbolCount; ++i) {
            reader.setPointerIndex(entryPos);
            ElfSymbol sym = ElfSymbol.createElfSymbol(reader, i, this, stringTable, header);
            symbolList.add(sym);
            entryPos += entrySize;
        }
        reader.setPointerIndex(ptr);
        this.symbols = new ElfSymbol[symbolList.size()];
        symbolList.toArray(this.symbols);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public ElfStringTable getStringTable() {
        return this.stringTable;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public ElfSymbol[] getSymbols() {
        return this.symbols;
    }

    public int getSymbolIndex(ElfSymbol symbol) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].equals(symbol)) continue;
            return i;
        }
        return -1;
    }

    public ElfSymbol getSymbolAt(long addr) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (this.symbols[i].getValue() != addr) continue;
            return this.symbols[i];
        }
        return null;
    }

    public ElfSymbol[] getGlobalSymbols() {
        ArrayList<ElfSymbol> list = new ArrayList<ElfSymbol>();
        for (int i = 0; i < this.symbols.length; ++i) {
            if (this.symbols[i].getBind() != 1) continue;
            list.add(this.symbols[i]);
        }
        ElfSymbol[] array = new ElfSymbol[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getSourceFiles() {
        ArrayList<String> list = new ArrayList<String>();
        for (int j = 0; j < this.symbols.length; ++j) {
            String name;
            if (this.symbols[j].getType() != 4 || (name = this.symbols[j].getNameAsString()) == null) continue;
            list.add(this.symbols[j].getNameAsString());
        }
        String[] files = new String[list.size()];
        list.toArray(files);
        return files;
    }

    public void addSymbol(ElfSymbol symbol) {
        ElfSymbol[] tmp = new ElfSymbol[this.symbols.length + 1];
        System.arraycopy(this.symbols, 0, tmp, 0, this.symbols.length);
        tmp[tmp.length - 1] = symbol;
        this.symbols = tmp;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = null;
        int index = 0;
        for (int i = 0; i < this.symbols.length; ++i) {
            byte[] symbytes = this.symbols[i].toBytes(dc);
            if (i == 0) {
                bytes = new byte[this.symbols.length * symbytes.length];
            }
            System.arraycopy(symbytes, 0, bytes, index, symbytes.length);
            index += symbytes.length;
        }
        return bytes;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddressOffset() {
        return this.addrOffset;
    }

    public ElfSectionHeader getTableSectionHeader() {
        return this.symbolTableSection;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public int getEntrySize() {
        return (int)this.entrySize;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        String dtName = this.is32bit ? "Elf32_Sym" : "Elf64_Sym";
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), dtName, 0);
        struct.add(DWORD, "st_name", null);
        if (this.is32bit) {
            struct.add(DWORD, "st_value", null);
            struct.add(DWORD, "st_size", null);
            struct.add(BYTE, "st_info", null);
            struct.add(BYTE, "st_other", null);
            struct.add(WORD, "st_shndx", null);
        } else {
            struct.add(BYTE, "st_info", null);
            struct.add(BYTE, "st_other", null);
            struct.add(WORD, "st_shndx", null);
            struct.add(QWORD, "st_value", null);
            struct.add(QWORD, "st_size", null);
        }
        int sizeRemaining = this.getEntrySize() - struct.getLength();
        if (sizeRemaining > 0) {
            struct.add((DataType)new ArrayDataType((DataType)ByteDataType.dataType, sizeRemaining, 1), "st_unknown", null);
        }
        return new ArrayDataType((DataType)struct, (int)(this.length / this.entrySize), (int)this.entrySize);
    }
}

