/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class ElfRelocation
implements ByteArrayConverter,
StructConverter {
    protected static final String R_OFFSET_COMMENT = "location to apply the relocation action";
    protected static final String R_INFO_COMMENT = "the symbol table index and the type of relocation";
    protected static final String R_ADDEND_COMMENT = "a constant addend used to compute the relocatable field value";
    private long r_offset;
    private long r_info;
    private long r_addend;
    private boolean hasAddend;
    private boolean is32bit;
    private int relocationIndex;

    static ElfRelocation createElfRelocation(FactoryBundledWithBinaryReader reader, ElfHeader elfHeader, int relocationIndex, boolean withAddend) throws IOException {
        Class<? extends ElfRelocation> elfRelocationClass = ElfRelocation.getElfRelocationClass(elfHeader);
        ElfRelocation elfRelocation = (ElfRelocation)reader.getFactory().create(elfRelocationClass, new Object[0]);
        elfRelocation.initElfRelocation(reader, elfHeader, relocationIndex, withAddend);
        return elfRelocation;
    }

    static ElfRelocation createElfRelocation(GenericFactory factory, ElfHeader elfHeader, int relocationIndex, boolean withAddend) {
        Class<? extends ElfRelocation> elfRelocationClass = ElfRelocation.getElfRelocationClass(elfHeader);
        ElfRelocation elfRelocation = (ElfRelocation)factory.create(elfRelocationClass, new Object[0]);
        try {
            elfRelocation.initElfRelocation(null, elfHeader, relocationIndex, withAddend);
        }
        catch (IOException e) {
            throw new AssertException("unexpected IO error", (Throwable)e);
        }
        return elfRelocation;
    }

    private static Class<? extends ElfRelocation> getElfRelocationClass(ElfHeader elfHeader) {
        Class<? extends ElfRelocation> elfRelocationClass = null;
        ElfLoadAdapter loadAdapter = elfHeader.getLoadAdapter();
        if (loadAdapter != null) {
            elfRelocationClass = loadAdapter.getRelocationClass(elfHeader);
        }
        if (elfRelocationClass == null) {
            elfRelocationClass = ElfRelocation.class;
        }
        return elfRelocationClass;
    }

    protected void initElfRelocation(FactoryBundledWithBinaryReader reader, ElfHeader elfHeader, int relocationTableIndex, boolean withAddend) throws IOException {
        this.is32bit = elfHeader.is32Bit();
        this.relocationIndex = relocationTableIndex;
        this.hasAddend = withAddend;
        if (reader != null) {
            this.readEntryData(reader);
        }
    }

    private void readEntryData(FactoryBundledWithBinaryReader reader) throws IOException {
        if (this.is32bit) {
            this.r_offset = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.r_info = (long)reader.readNextInt() & 0xFFFFFFFFL;
            if (this.hasAddend) {
                this.r_addend = (long)reader.readNextInt() & 0xFFFFFFFFL;
            }
        } else {
            this.r_offset = reader.readNextLong();
            this.r_info = reader.readNextLong();
            if (this.hasAddend) {
                this.r_addend = reader.readNextLong();
            }
        }
    }

    public int getRelocationIndex() {
        return this.relocationIndex;
    }

    protected boolean is32Bit() {
        return this.is32bit;
    }

    public long getOffset() {
        return this.r_offset;
    }

    public void setOffset(int offset) {
        this.r_offset = (long)offset & 0xFFFFFFFFL;
    }

    public void setOffset(long offset) {
        this.r_offset = offset;
    }

    public int getSymbolIndex() {
        return (int)(this.is32bit ? this.r_info >> 8 : this.r_info >> 32);
    }

    public int getType() {
        return (int)(this.is32bit ? this.r_info & 0xFFL : this.r_info & 0xFFFFFFFFL);
    }

    public long getRelocationInfo() {
        return this.r_info;
    }

    public long getAddend() {
        return this.r_addend;
    }

    public boolean hasAddend() {
        return this.hasAddend;
    }

    @Override
    public DataType toDataType() {
        Object dtName;
        Object object = dtName = this.is32bit ? "Elf32_Rel" : "Elf64_Rel";
        if (this.hasAddend) {
            dtName = (String)dtName + "a";
        }
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), (String)dtName, 0);
        DataType fieldDt = this.is32bit ? DWORD : QWORD;
        struct.add(fieldDt, "r_offset", R_OFFSET_COMMENT);
        struct.add(fieldDt, "r_info", R_INFO_COMMENT);
        if (this.hasAddend) {
            struct.add(fieldDt, "r_addend", R_ADDEND_COMMENT);
        }
        return struct;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.sizeof()];
        if (this.is32bit) {
            dc.putInt(bytes, 0, (int)this.r_offset);
            dc.putInt(bytes, 4, (int)this.r_info);
        } else {
            dc.putLong(bytes, 0, this.r_offset);
            dc.putLong(bytes, 8, this.r_info);
        }
        return bytes;
    }

    public String toString() {
        String str = "Offset: 0x" + Long.toHexString(this.getOffset()) + " - Type: 0x" + Long.toHexString(this.getType()) + " - Symbol: 0x" + Long.toHexString(this.getSymbolIndex());
        if (this.hasAddend) {
            str = str + " - Addend: 0x" + Long.toHexString(this.getAddend());
        }
        return str;
    }

    protected int sizeof() {
        if (this.hasAddend) {
            return this.is32bit ? 12 : 24;
        }
        return this.is32bit ? 8 : 16;
    }
}

