/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFForm;
import java.io.IOException;

public class DWARFAttributeSpecification {
    private final int attribute;
    private final DWARFForm attributeForm;

    public static DWARFAttributeSpecification read(BinaryReader reader) throws IOException {
        int attribute = LEB128.decode32u(reader);
        DWARFForm attributeForm = DWARFForm.find(LEB128.decode32u(reader));
        return attribute != 0 && attributeForm != DWARFForm.NULL ? new DWARFAttributeSpecification(attribute, attributeForm) : null;
    }

    public DWARFAttributeSpecification(int attribute, DWARFForm attributeForm) {
        this.attribute = attribute;
        this.attributeForm = attributeForm;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public DWARFForm getAttributeForm() {
        return this.attributeForm;
    }

    public String toString() {
        return DWARFUtil.toString(DWARFAttribute.class, this.getAttribute()) + "->" + this.getAttributeForm();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attribute;
        result = 31 * result + (this.attributeForm == null ? 0 : this.attributeForm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DWARFAttributeSpecification)) {
            return false;
        }
        DWARFAttributeSpecification other = (DWARFAttributeSpecification)obj;
        if (this.attribute != other.attribute) {
            return false;
        }
        return this.attributeForm == other.attributeForm;
    }
}

