/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.ColorAndStyle;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.options.ScreenElement;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class SymbolInspector
implements OptionsChangeListener {
    private Component repaintComp;
    private Program program;
    private ToolOptions optionsObject;
    private Listing listing;
    private Memory memory;
    private Map<String, Object> cache = new HashMap<String, Object>();

    public SymbolInspector(ServiceProvider serviceProvider, Component repaintComp) {
        this(SymbolInspector.getOptions(serviceProvider), repaintComp);
    }

    public SymbolInspector(ToolOptions options, Component repaintComp) {
        this.optionsObject = options;
        this.optionsObject.addOptionsChangeListener((OptionsChangeListener)this);
        this.repaintComp = repaintComp;
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        if (options.getName().equals("Listing Display")) {
            if (this.cache.containsKey(name)) {
                this.cache.put(name, newValue);
            }
            if (this.repaintComp != null) {
                this.repaintComp.repaint();
            }
        }
    }

    public void setProgram(Program p) {
        if (this.program == p) {
            return;
        }
        if (this.program != null) {
            this.program = null;
            this.listing = null;
            this.memory = null;
        }
        if (p != null) {
            this.program = p;
            this.listing = p.getListing();
            this.memory = p.getMemory();
        }
    }

    public Program getProgram() {
        return this.program;
    }

    public void dispose() {
        if (this.optionsObject != null) {
            this.optionsObject.removeOptionsChangeListener((OptionsChangeListener)this);
            this.optionsObject = null;
        }
        this.repaintComp = null;
        this.setProgram(null);
    }

    public boolean isBadReferenceSymbol(Symbol s) {
        if (this.memory == null) {
            return true;
        }
        Address a = s.getAddress();
        if (a.isMemoryAddress()) {
            return !this.memory.contains(s.getAddress());
        }
        return false;
    }

    public boolean isDataSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Address addr = s.getAddress();
        Data data = this.listing.getDataContaining(addr);
        return data != null;
    }

    public boolean isDeadCodeSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        ReferenceManager refMgr = this.program.getReferenceManager();
        return !refMgr.hasReferencesTo(s.getAddress());
    }

    public boolean isEntryPointSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return s.isExternalEntryPoint();
    }

    public boolean isFunctionSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return s.getSymbolType() == SymbolType.FUNCTION;
    }

    public boolean isVariableSymbol(Symbol s) {
        Symbol parent = s.getParentSymbol();
        if (parent == null || !this.isFunctionSymbol(parent)) {
            return false;
        }
        SymbolType type = s.getSymbolType();
        return type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR || type == SymbolType.GLOBAL_VAR;
    }

    public boolean isGlobalSymbol(Symbol s) {
        return s.isGlobal();
    }

    public boolean isInstructionSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Address addr = s.getAddress();
        Instruction instr = this.listing.getInstructionContaining(addr);
        return instr != null;
    }

    public boolean isLocalSymbol(Symbol s) {
        for (Symbol p = s.getParentSymbol(); p != null; p = p.getParentSymbol()) {
            if (!(p instanceof FunctionSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean isNonPrimarySymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return !s.isPrimary();
    }

    public boolean isOffcutSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Address addr = s.getAddress();
        CodeUnit cu = this.listing.getCodeUnitContaining(addr);
        if (cu != null && cu.getLength() > 1) {
            return cu.getMinAddress().compareTo((Object)addr) < 0;
        }
        return false;
    }

    public boolean isPrimarySymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return s.isPrimary();
    }

    public boolean isSubroutineSymbol(Symbol s) {
        Reference[] refsTo;
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        for (Reference element : refsTo = s.getReferences(null)) {
            if (!element.getReferenceType().isCall()) continue;
            return true;
        }
        return false;
    }

    public boolean isExternalSymbol(Symbol s) {
        return s.getAddress().isExternalAddress();
    }

    public ColorAndStyle getColorAndStyle(Symbol s) {
        ScreenElement se = this.getScreenElement(s);
        Color color = this.getColor(se);
        int style = this.getStyle(se);
        return new ColorAndStyle(color, style);
    }

    public Color getColor(Symbol s) {
        return this.getColor(this.getScreenElement(s));
    }

    public int getStyle(Symbol s) {
        return this.getStyle(this.getScreenElement(s));
    }

    public ScreenElement getScreenElement(Symbol s) {
        if (s == null) {
            return null;
        }
        if (this.isExternalSymbol(s)) {
            return this.getExternalScreenElement(s);
        }
        if (this.isBadReferenceSymbol(s)) {
            return OptionsGui.BAD_REF_ADDR;
        }
        if (this.isOffcutSymbol(s)) {
            return OptionsGui.XREF_OFFCUT;
        }
        if (this.isEntryPointSymbol(s)) {
            return OptionsGui.ENTRY_POINT;
        }
        if (this.isDeadCodeSymbol(s)) {
            return OptionsGui.LABELS_UNREFD;
        }
        if (this.isFunctionSymbol(s)) {
            return OptionsGui.FUN_NAME;
        }
        if (this.isVariableSymbol(s)) {
            if (s.getSymbolType() == SymbolType.PARAMETER) {
                Function function = (Function)s.getParentNamespace();
                return function.hasCustomVariableStorage() ? OptionsGui.PARAMETER_CUSTOM : OptionsGui.PARAMETER_DYNAMIC;
            }
            return OptionsGui.VARIABLE;
        }
        if (this.isPrimarySymbol(s)) {
            return OptionsGui.LABELS_PRIMARY;
        }
        if (this.isLocalSymbol(s)) {
            return OptionsGui.LABELS_LOCAL;
        }
        if (this.isNonPrimarySymbol(s)) {
            return OptionsGui.LABELS_NON_PRIMARY;
        }
        return null;
    }

    public Color getOffcutSymbolColor() {
        return this.getColor(OptionsGui.XREF_OFFCUT);
    }

    public int getOffcutSymbolStyle() {
        return this.getStyle(OptionsGui.XREF_OFFCUT);
    }

    private ScreenElement getExternalScreenElement(Symbol s) {
        String path = this.program.getExternalManager().getExternalLibraryPath(this.getExternalName(s));
        if (path != null && path.length() > 0) {
            return OptionsGui.EXT_REF_RESOLVED;
        }
        return OptionsGui.BAD_REF_ADDR;
    }

    private String getExternalName(Symbol s) {
        if (!s.isExternal()) {
            return null;
        }
        if (s.getSymbolType() == SymbolType.LIBRARY) {
            return s.getName();
        }
        Symbol parent = s.getParentSymbol();
        while (parent.getSymbolType() != SymbolType.GLOBAL) {
            if (parent.getSymbolType() == SymbolType.LIBRARY) {
                return parent.getName();
            }
            parent = parent.getParentSymbol();
        }
        return null;
    }

    private static ToolOptions getOptions(ServiceProvider serviceProvider) {
        OptionsService service = (OptionsService)serviceProvider.getService(OptionsService.class);
        return service.getOptions("Listing Display");
    }

    private Color getColor(ScreenElement se) {
        if (se == null) {
            return Color.BLACK;
        }
        String optionName = se.getColorOptionName();
        Color color = (Color)this.cache.get(optionName);
        if (color == null) {
            color = this.optionsObject.getColor(se.getColorOptionName(), se.getDefaultColor());
            this.cache.put(optionName, color);
        }
        return color;
    }

    private int getStyle(ScreenElement se) {
        if (se == null) {
            return -1;
        }
        String optionName = se.getStyleOptionName();
        Integer style = (Integer)this.cache.get(optionName);
        if (style == null) {
            style = this.optionsObject.getInt(se.getStyleOptionName(), -1);
            this.cache.put(optionName, style);
        }
        return style;
    }
}

