/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.store.LockException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;

public class MemoryBlockUtils {
    public static MemoryBlock createUninitializedBlock(Program program, boolean isOverlay, String name, Address start, long length, String comment, String source, boolean r, boolean w, boolean x, MessageLog log) {
        Memory memory = program.getMemory();
        try {
            MemoryBlock block = memory.createUninitializedBlock(name, start, length, isOverlay);
            MemoryBlockUtils.setBlockAttributes(block, comment, source, r, w, x);
            MemoryBlockUtils.adjustFragment(program, block.getStart(), name);
            return block;
        }
        catch (LockException e) {
            log.appendMsg("Failed to create memory block: exclusive lock/checkout required");
        }
        catch (Exception e) {
            log.appendMsg("Failed to create '" + name + "' memory block: " + e.getMessage());
        }
        return null;
    }

    public static MemoryBlock createInitializedBlock(Program program, boolean isOverlay, String name, Address start, long length, String comment, String source, boolean r, boolean w, boolean x, MessageLog log) {
        Memory memory = program.getMemory();
        try {
            MemoryBlock block = memory.createInitializedBlock(name, start, null, length, TaskMonitor.DUMMY, isOverlay);
            MemoryBlockUtils.setBlockAttributes(block, comment, source, r, w, x);
            MemoryBlockUtils.adjustFragment(program, block.getStart(), name);
            return block;
        }
        catch (LockException e) {
            log.appendMsg("Failed to create memory block: exclusive lock/checkout required");
        }
        catch (Exception e) {
            log.appendMsg("Failed to create '" + name + "' memory block: " + e.getMessage());
        }
        return null;
    }

    public static MemoryBlock createBitMappedBlock(Program program, String name, Address start, Address base, int length, String comment, String source, boolean r, boolean w, boolean x, MessageLog log) {
        Memory memory = program.getMemory();
        try {
            MemoryBlock block = memory.createBitMappedBlock(name, start, base, (long)length);
            MemoryBlockUtils.setBlockAttributes(block, comment, source, r, w, x);
            MemoryBlockUtils.adjustFragment(program, start, name);
            return block;
        }
        catch (LockException e) {
            log.appendMsg("Failed to create '" + name + "'bit mapped memory block: exclusive lock/checkout required");
        }
        catch (Exception e) {
            log.appendMsg("Failed to create '" + name + "' mapped memory block: " + e.getMessage());
        }
        return null;
    }

    public static MemoryBlock createByteMappedBlock(Program program, String name, Address start, Address base, int length, String comment, String source, boolean r, boolean w, boolean x, MessageLog log) {
        Memory memory = program.getMemory();
        try {
            MemoryBlock block = memory.createByteMappedBlock(name, start, base, (long)length);
            MemoryBlockUtils.setBlockAttributes(block, comment, source, r, w, x);
            MemoryBlockUtils.adjustFragment(program, start, name);
            return block;
        }
        catch (LockException e) {
            log.appendMsg("Failed to create '" + name + "' byte mapped memory block: exclusive lock/checkout required");
        }
        catch (Exception e) {
            log.appendMsg("Failed to create '" + name + "' mapped memory block: " + e.getMessage());
        }
        return null;
    }

    public static MemoryBlock createInitializedBlock(Program program, boolean isOverlay, String name, Address start, FileBytes fileBytes, long offset, long length, String comment, String source, boolean r, boolean w, boolean x, MessageLog log) throws AddressOverflowException {
        MemoryBlock block;
        if (!program.hasExclusiveAccess()) {
            log.appendMsg("Failed to create memory block: exclusive access/checkout required");
            return null;
        }
        try {
            try {
                block = program.getMemory().createInitializedBlock(name, start, fileBytes, offset, length, isOverlay);
            }
            catch (MemoryConflictException | DuplicateNameException e) {
                block = MemoryBlockUtils.createBlockNoDuplicateName(program, name, start, fileBytes, offset, length);
                log.appendMsg("Conflict attempting to create memory block: " + name + " at address " + start.toString() + " Created block in new overlay instead");
            }
        }
        catch (LockException | MemoryConflictException e) {
            throw new RuntimeException(e);
        }
        MemoryBlockUtils.setBlockAttributes(block, comment, source, r, w, x);
        MemoryBlockUtils.adjustFragment(program, block.getStart(), name);
        return block;
    }

    private static MemoryBlock createBlockNoDuplicateName(Program program, String blockName, Address start, FileBytes fileBytes, long offset, long length) throws LockException, MemoryConflictException, AddressOverflowException {
        int count = 1;
        Object name = blockName;
        while (true) {
            try {
                return program.getMemory().createInitializedBlock((String)name, start, fileBytes, offset, length, true);
            }
            catch (DuplicateNameException e) {
                name = blockName + "_" + count++;
                continue;
            }
            break;
        }
    }

    public static MemoryBlock createInitializedBlock(Program program, boolean isOverlay, String name, Address start, InputStream dataInput, long dataLength, String comment, String source, boolean r, boolean w, boolean x, MessageLog log, TaskMonitor monitor) throws AddressOverflowException {
        MemoryBlock block;
        if (!program.hasExclusiveAccess()) {
            log.appendMsg("Failed to create memory block: exclusive access/checkout required");
            return null;
        }
        Memory memory = program.getMemory();
        try {
            try {
                block = memory.createInitializedBlock(name, start, dataInput, dataLength, monitor, isOverlay);
            }
            catch (MemoryConflictException e) {
                block = memory.createInitializedBlock(name, start, dataInput, dataLength, monitor, true);
            }
        }
        catch (LockException | MemoryConflictException | DuplicateNameException e) {
            throw new RuntimeException(e);
        }
        catch (CancelledException e) {
            return null;
        }
        MemoryBlockUtils.setBlockAttributes(block, comment, source, r, w, x);
        MemoryBlockUtils.adjustFragment(program, block.getStart(), block.getName());
        return block;
    }

    public static void adjustFragment(Program program, Address address, String name) {
        String[] treeNames;
        Listing listing = program.getListing();
        for (String treeName : treeNames = listing.getTreeNames()) {
            try {
                ProgramFragment frag = listing.getFragment(treeName, address);
                frag.setName(name);
            }
            catch (DuplicateNameException e) {
                Msg.warn(MemoryBlockUtils.class, (Object)"Could not rename fragment to match newly created block because of name conflict");
            }
        }
    }

    public static FileBytes createFileBytes(Program program, ByteProvider provider, TaskMonitor monitor) throws IOException, CancelledException {
        return MemoryBlockUtils.createFileBytes(program, provider, 0L, provider.length(), monitor);
    }

    public static FileBytes createFileBytes(Program program, ByteProvider provider, long offset, long length, TaskMonitor monitor) throws IOException, CancelledException {
        Memory memory = program.getMemory();
        try (InputStream fis = provider.getInputStream(offset);){
            FileBytes fileBytes = memory.createFileBytes(provider.getName(), offset, length, fis, monitor);
            return fileBytes;
        }
    }

    private static void setBlockAttributes(MemoryBlock block, String comment, String source, boolean r, boolean w, boolean x) {
        block.setComment(comment);
        block.setSourceName(source);
        block.setRead(r);
        block.setWrite(w);
        block.setExecute(x);
    }
}

