/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.app.events.CloseProgramPluginEvent;
import ghidra.app.events.OpenProgramPluginEvent;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramVisibilityChangePluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.app.plugin.core.progmgr.TransactionMonitor;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JComponent;
import org.jdom.Element;

class MultiProgramManager
implements DomainObjectListener,
TransactionListener {
    private static int nextProgramInfoInstance = 0;
    private ProgramManagerPlugin plugin;
    private PluginTool tool;
    private ArrayList<ProgramInfo> openProgramList;
    private HashMap<Program, ProgramInfo> programMap;
    private ProgramInfo currentInfo;
    private TransactionMonitor txMonitor;
    private MyFolderListener folderListener;
    private Runnable programChangedRunnable;

    MultiProgramManager(ProgramManagerPlugin programManagerPlugin) {
        this.plugin = programManagerPlugin;
        this.tool = programManagerPlugin.getTool();
        this.openProgramList = new ArrayList();
        this.programMap = new HashMap();
        this.txMonitor = new TransactionMonitor();
        this.txMonitor.setName("Transaction Open (Program being modified)");
        this.tool.addStatusComponent((JComponent)this.txMonitor, true, true);
        this.folderListener = new MyFolderListener();
        this.tool.getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        this.programChangedRunnable = () -> {
            if (this.tool == null) {
                return;
            }
            this.plugin.updateProgramActions();
        };
    }

    void addProgram(Program p, URL ghidraURL, int state) {
        ProgramInfo oldInfo = this.programMap.get(p);
        if (oldInfo == null) {
            p.addConsumer((Object)this.tool);
            ProgramInfo info = new ProgramInfo(p, state != 0);
            info.ghidraURL = ghidraURL;
            this.openProgramList.add(info);
            Collections.sort(this.openProgramList);
            this.programMap.put(p, info);
            this.fireOpenEvents(p);
            p.addListener((DomainObjectListener)this);
            p.addTransactionListener((TransactionListener)this);
        } else if (!oldInfo.visible && state != 0) {
            oldInfo.setVisible(true);
        }
        if (state == 1) {
            this.saveLocation();
            this.setCurrentProgram(p);
        }
    }

    void dispose() {
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        this.fireActivatedEvent(null);
        for (Program p : this.programMap.keySet()) {
            p.removeListener((DomainObjectListener)this);
            p.removeTransactionListener((TransactionListener)this);
            this.fireCloseEvents(p);
            p.release((Object)this.tool);
        }
        this.programMap.clear();
        this.openProgramList.clear();
        this.tool.setSubTitle("");
        this.tool.removeStatusComponent((JComponent)this.txMonitor);
        this.tool = null;
        this.plugin = null;
    }

    void removeProgram(Program p) {
        ProgramInfo info = this.programMap.get(p);
        if (info != null) {
            if (info.owner != null) {
                info.setVisible(false);
                if (info == this.currentInfo) {
                    ProgramInfo newCurrent = this.findNextCurrent();
                    this.setCurrentProgram(newCurrent);
                }
            } else {
                p.removeTransactionListener((TransactionListener)this);
                this.programMap.remove(p);
                p.removeListener((DomainObjectListener)this);
                this.openProgramList.remove(info);
                if (info == this.currentInfo) {
                    ProgramInfo newCurrent = this.findNextCurrent();
                    this.setCurrentProgram(newCurrent);
                }
                this.fireCloseEvents(p);
                p.release((Object)this.tool);
                if (this.openProgramList.isEmpty()) {
                    this.plugin.getTool().clearLastEvents();
                }
            }
        }
    }

    private ProgramInfo findNextCurrent() {
        for (ProgramInfo pi : this.openProgramList) {
            if (!pi.visible) continue;
            return pi;
        }
        return null;
    }

    Program[] getOtherPrograms() {
        Program currentProgram = this.getCurrentProgram();
        ArrayList<Program> list = new ArrayList<Program>();
        int size = this.openProgramList.size();
        for (int index = 0; index < size; ++index) {
            Program program = this.openProgramList.get((int)index).program;
            if (currentProgram == program) continue;
            list.add(program);
        }
        return list.toArray(new Program[list.size()]);
    }

    Program[] getAllPrograms() {
        Program[] programs = new Program[this.openProgramList.size()];
        for (int i = 0; i < programs.length; ++i) {
            programs[i] = this.openProgramList.get((int)i).program;
        }
        return programs;
    }

    Program getCurrentProgram() {
        if (this.currentInfo != null) {
            return this.currentInfo.program;
        }
        return null;
    }

    void setCurrentProgram(Program p) {
        if (this.currentInfo != null && this.currentInfo.program.equals(p)) {
            return;
        }
        ProgramInfo info = this.programMap.get(p);
        if (info != null) {
            this.setCurrentProgram(info);
        }
    }

    Program getProgram(Address addr) {
        for (ProgramInfo pi : this.openProgramList) {
            if (!pi.program.getMemory().contains(addr)) continue;
            return pi.program;
        }
        return null;
    }

    void saveLocation() {
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (historyService == null) {
            return;
        }
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService == null) {
            return;
        }
        Navigatable defaultNavigatable = gotoService.getDefaultNavigatable();
        if (defaultNavigatable == null || defaultNavigatable.getProgram() == null) {
            return;
        }
        historyService.addNewLocation(defaultNavigatable);
    }

    private void setCurrentProgram(ProgramInfo info) {
        Program newProgram;
        if (this.currentInfo == info) {
            return;
        }
        Program program = newProgram = info == null ? null : info.program;
        if (this.currentInfo != null) {
            this.currentInfo.lastState = this.tool.getTransientState();
            this.tool.setSubTitle("");
            this.txMonitor.setProgram(null);
        }
        this.currentInfo = info;
        TransientToolState toolState = null;
        if (this.currentInfo != null) {
            this.currentInfo.setVisible(true);
            DomainFile df = this.currentInfo.program.getDomainFile();
            Object title = df.toString();
            if (df.isReadOnly()) {
                title = (String)title + " [Read-Only]";
            }
            this.tool.setSubTitle((String)title);
            this.txMonitor.setProgram(this.currentInfo.program);
            if (this.currentInfo.lastState != null) {
                toolState = this.currentInfo.lastState;
            }
        }
        this.fireActivatedEvent(newProgram);
        if (toolState != null) {
            toolState.restoreTool();
        }
    }

    private void fireOpenEvents(Program program) {
        this.plugin.firePluginEvent(new ProgramOpenedPluginEvent("", program));
        this.plugin.firePluginEvent(new OpenProgramPluginEvent("", program));
    }

    private void fireCloseEvents(Program program) {
        this.plugin.firePluginEvent(new ProgramClosedPluginEvent("", program));
        this.plugin.firePluginEvent(new CloseProgramPluginEvent("", program, true));
    }

    private void fireActivatedEvent(Program newProgram) {
        this.plugin.firePluginEvent(new ProgramActivatedPluginEvent("", newProgram));
    }

    private void fireVisibilityChangeEvent(Program program, boolean isVisible) {
        this.plugin.firePluginEvent(new ProgramVisibilityChangePluginEvent("", program, isVisible));
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!(ev.getSource() instanceof Program)) {
            return;
        }
        Program program = (Program)ev.getSource();
        if (ev.containsEvent(2) || ev.containsEvent(8)) {
            for (int i = 0; i < ev.numRecords(); ++i) {
                DomainObjectChangeRecord docr = ev.getChangeRecord(i);
                int eventType = docr.getEventType();
                if (eventType == 2) {
                    if (this.currentInfo == null || this.currentInfo.program != program) continue;
                    String name = program.getDomainFile().toString();
                    this.tool.setSubTitle(name);
                    continue;
                }
                if (eventType != 8) continue;
                Throwable t = (Throwable)docr.getNewValue();
                String msg = t instanceof NoSuchObjectException ? program.getName() + " was closed due to an unrecoverable error!\nThis error could be the result of your computer becoming suspended\nor sleeping allowing the network connection with the Ghidra Server\nto fail." : program.getName() + " was closed due to an unrecoverable error!\n \nSuch failures are generally due to an IO Error caused\nby the local filesystem or server.";
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Severe Error Condition", (Object)msg);
                this.removeProgram(program);
                return;
            }
        }
    }

    public boolean isEmpty() {
        return this.openProgramList.isEmpty();
    }

    public boolean contains(Program program) {
        return this.programMap.containsKey(program);
    }

    boolean isVisible(Program program) {
        ProgramInfo info = this.programMap.get(program);
        return info != null ? info.visible : false;
    }

    void releaseProgram(Program program, Object owner) {
        ProgramInfo info = this.programMap.get(program);
        if (info != null && info.owner == owner) {
            info.owner = null;
            if (!info.visible) {
                if (program.isChanged()) {
                    info.setVisible(true);
                }
                this.plugin.closeProgram(program, false);
            } else if (program.isTemporary()) {
                this.plugin.closeProgram(program, false);
            }
        }
    }

    boolean setPersistentOwner(Program program, Object owner) {
        ProgramInfo info = this.programMap.get(program);
        if (info != null && info.owner == null) {
            info.owner = owner;
            return true;
        }
        return false;
    }

    public boolean isPersistent(Program program) {
        ProgramInfo info = this.programMap.get(program);
        return info != null && info.owner != null;
    }

    public void transactionEnded(DomainObjectAdapterDB domainObj) {
    }

    public void transactionStarted(DomainObjectAdapterDB domainObj, Transaction tx) {
    }

    public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
    }

    public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        SystemUtilities.runSwingLater((Runnable)this.programChangedRunnable);
    }

    public Program getOpenProgram(URL ghidraURL) {
        if (!GhidraURL.isServerRepositoryURL((URL)ghidraURL)) {
            return null;
        }
        URL normalizedURL = GhidraURL.getNormalizedURL((URL)ghidraURL);
        for (ProgramInfo info : this.programMap.values()) {
            URL url = info.ghidraURL;
            if (url == null || !url.equals(normalizedURL)) continue;
            return info.program;
        }
        return null;
    }

    public Program getOpenProgram(DomainFile domainFile, int version) {
        for (Program program : this.programMap.keySet()) {
            DomainFile programDomainFile = program.getDomainFile();
            if (!this.filesMatch(domainFile, version, programDomainFile)) continue;
            return program;
        }
        return null;
    }

    private boolean filesMatch(DomainFile file, int version, DomainFile openFile) {
        if (!file.getPathname().equals(openFile.getPathname())) {
            return false;
        }
        if (file.isCheckedOut() != openFile.isCheckedOut()) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)file.getProjectLocator(), (Object)openFile.getProjectLocator())) {
            return false;
        }
        int openVersion = openFile.isReadOnly() ? openFile.getVersion() : -1;
        return version == openVersion;
    }

    private class ProgramInfo
    implements Comparable<ProgramInfo> {
        Program program;
        URL ghidraURL;
        TransientToolState lastState;
        private int instance;
        boolean visible;
        Object owner;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProgramInfo(Program p, boolean visible) {
            this.program = p;
            this.visible = visible;
            Class<ProgramInfo> clazz = ProgramInfo.class;
            synchronized (ProgramInfo.class) {
                this.instance = ++nextProgramInfoInstance;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        public void setVisible(boolean state) {
            this.visible = state;
            MultiProgramManager.this.fireVisibilityChangeEvent(this.program, this.visible);
        }

        @Override
        public int compareTo(ProgramInfo info) {
            return this.instance - info.instance;
        }
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
            if (!MultiProgramManager.this.programMap.containsKey(oldObject)) {
                return;
            }
            Element dataState = null;
            if (MultiProgramManager.this.currentInfo != null && MultiProgramManager.this.currentInfo.program == oldObject) {
                dataState = MultiProgramManager.this.tool.saveDataStateToXml(true);
            }
            OpenProgramTask openTask = new OpenProgramTask(file, -1, (Object)this);
            openTask.setSilent();
            new TaskLauncher((Task)openTask, (Component)MultiProgramManager.this.tool.getToolFrame());
            Program openProgram = openTask.getOpenProgram();
            MultiProgramManager.this.plugin.openProgram(openProgram, dataState != null ? 1 : 2);
            openProgram.release((Object)this);
            MultiProgramManager.this.removeProgram((Program)oldObject);
            if (dataState != null) {
                MultiProgramManager.this.tool.restoreDataStateFromXml(dataState);
            }
        }
    }
}

