/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.memory.MemoryMapPlugin;
import ghidra.app.plugin.core.misc.RegisterField;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HelpLocation;
import ghidra.util.NamingUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SplitBlockDialog
extends DialogComponentProvider {
    private JTextField blockOneNameField;
    private JTextField blockOneStartField;
    private AddressInput blockOneEnd;
    private RegisterField blockOneLengthField;
    private JTextField blockTwoNameField;
    private AddressInput blockTwoStart;
    private JTextField blockTwoEndField;
    private RegisterField blockTwoLengthField;
    private MemoryBlock block;
    private AddressFactory addrFactory;
    private MemoryMapPlugin plugin;

    SplitBlockDialog(MemoryMapPlugin plugin, MemoryBlock block, AddressFactory af) {
        super("Split Block");
        this.plugin = plugin;
        this.block = block;
        this.addrFactory = af;
        this.setHelpLocation(new HelpLocation("MemoryMapPlugin", "Split Block"));
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.setFields();
        this.addListeners();
    }

    protected void okCallback() {
        Object newBlockName = this.blockTwoNameField.getText();
        if (((String)newBlockName).length() == 0) {
            newBlockName = this.block.getName() + ".split";
            this.blockTwoNameField.setText((String)newBlockName);
        }
        if (!this.plugin.getMemoryMapManager().isValidBlockName((String)newBlockName)) {
            this.setStatusText("Block name already exists");
            return;
        }
        if (!NamingUtilities.isValidName((String)newBlockName)) {
            this.setStatusText("Invalid Block Name: " + (String)newBlockName);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.plugin.getMemoryMapManager().splitBlock(this.block, this.blockTwoStart.getAddress(), (String)newBlockName);
        this.close();
    }

    private JPanel create() {
        JPanel panelOne = new JPanel((LayoutManager)new PairLayout(5, 5, 150));
        panelOne.setBorder(BorderFactory.createTitledBorder("Block to Split"));
        this.blockOneNameField = new JTextField(10);
        this.blockOneNameField.setName("BlockOneName");
        this.blockOneStartField = new JTextField(10);
        this.blockOneStartField.setName("BlockOneStart");
        this.blockOneEnd = new AddressInput();
        this.blockOneEnd.setName("BlockOneEnd");
        this.blockOneLengthField = new RegisterField(32, null, false);
        this.blockOneLengthField.setName("BlockOneLength");
        panelOne.add((Component)new GLabel("Block Name:", 4));
        panelOne.add(this.blockOneNameField);
        panelOne.add((Component)new GLabel("Start Address:", 4));
        panelOne.add(this.blockOneStartField);
        panelOne.add((Component)new GLabel("End Address:", 4));
        panelOne.add(this.blockOneEnd);
        panelOne.add((Component)new GLabel("Block Length:", 4));
        panelOne.add(this.blockOneLengthField);
        JPanel panelTwo = new JPanel((LayoutManager)new PairLayout(5, 5, 150));
        panelTwo.setBorder(BorderFactory.createTitledBorder("New Block"));
        this.blockTwoNameField = new JTextField(10);
        this.blockTwoNameField.setName("BlockTwoName");
        this.blockTwoStart = new AddressInput();
        this.blockTwoStart.setName("BlockTwoStart");
        this.blockTwoEndField = new JTextField(10);
        this.blockTwoEndField.setName("BlockTwoEnd");
        this.blockTwoLengthField = new RegisterField(32, null, false);
        this.blockTwoLengthField.setName("BlockTwoLength");
        panelTwo.add((Component)new GLabel("Block Name:", 4));
        panelTwo.add(this.blockTwoNameField);
        panelTwo.add((Component)new GLabel("Start Address:", 4));
        panelTwo.add(this.blockTwoStart);
        panelTwo.add((Component)new GLabel("End Address:", 4));
        panelTwo.add(this.blockTwoEndField);
        panelTwo.add((Component)new GLabel("Block Length:", 4));
        panelTwo.add(this.blockTwoLengthField);
        JPanel mainPanel = new JPanel();
        BoxLayout bl = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(bl);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(panelOne);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(panelTwo);
        return mainPanel;
    }

    private void setFields() {
        String name = this.block.getName();
        this.blockOneNameField.setText(name);
        this.blockOneNameField.setEnabled(false);
        Address startAddr = this.block.getStart();
        Address endAddr = this.block.getEnd();
        this.blockOneStartField.setText(startAddr.toString());
        this.blockOneStartField.setEnabled(false);
        this.blockOneEnd.setAddressFactory(this.addrFactory);
        this.blockOneEnd.setAddress(endAddr);
        this.blockOneEnd.setAddressSpaceEditable(false);
        this.blockOneLengthField.setValue(new Long(this.block.getSize()));
        this.blockTwoNameField.setText(name + ".split");
        this.blockTwoStart.setAddressFactory(this.addrFactory);
        this.blockTwoStart.setAddress(startAddr);
        this.blockTwoStart.setAddressSpaceEditable(false);
        this.blockTwoEndField.setText(endAddr.toString());
        this.blockTwoEndField.setEnabled(false);
    }

    private void addListeners() {
        this.blockOneLengthField.setChangeListener(new LengthChangeListener(this.blockOneLengthField));
        this.blockTwoLengthField.setChangeListener(new LengthChangeListener(this.blockTwoLengthField));
        this.blockOneEnd.addChangeListener(new AddressChangeListener(this.blockOneEnd));
        this.blockTwoStart.addChangeListener(new AddressChangeListener(this.blockTwoStart));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitBlockDialog.this.setStatusText("");
            }
        };
        this.blockOneLengthField.addActionListener(al);
        this.blockTwoLengthField.addActionListener(al);
        this.blockOneEnd.addActionListener(al);
        this.blockTwoStart.addActionListener(al);
        this.blockTwoNameField.addActionListener(al);
    }

    private class AddressChangeListener
    implements ChangeListener {
        AddressInput source;

        public AddressChangeListener(AddressInput source) {
            this.source = source;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            SplitBlockDialog.this.setStatusText("");
            boolean ok = false;
            if (this.source == SplitBlockDialog.this.blockOneEnd) {
                ok = this.blockOneEndChanged();
            } else if (this.source == SplitBlockDialog.this.blockTwoStart) {
                ok = this.blockTwoStartChanged();
            }
            SplitBlockDialog.this.setOkEnabled(ok);
        }

        private Address getAddress() throws InvalidInputException {
            AddressInput field = this.source;
            Address addr = field.getAddress();
            if (addr == null && field.hasInput()) {
                throw new InvalidInputException();
            }
            return addr;
        }

        private boolean blockOneEndChanged() {
            Address start = SplitBlockDialog.this.block.getStart();
            Address end = null;
            try {
                end = this.getAddress();
            }
            catch (InvalidInputException e) {
                SplitBlockDialog.this.setStatusText("Invalid Address");
                return false;
            }
            if (end == null) {
                return false;
            }
            if (end.compareTo((Object)start) < 0) {
                SplitBlockDialog.this.setStatusText("End address must be greater than start");
                return false;
            }
            if (end.compareTo((Object)SplitBlockDialog.this.block.getEnd()) == 0) {
                return false;
            }
            long length = 0L;
            try {
                length = end.subtract(start) + 1L;
            }
            catch (IllegalArgumentException e) {
                SplitBlockDialog.this.setStatusText(e.getMessage());
                return false;
            }
            long blockSize = SplitBlockDialog.this.block.getSize();
            if (length > blockSize) {
                SplitBlockDialog.this.setStatusText("End address must be less than original block end (" + SplitBlockDialog.this.block.getEnd() + ")");
                return false;
            }
            SplitBlockDialog.this.blockOneLengthField.setValue(new Long(length));
            try {
                Address b2Start = end.addNoWrap(1L);
                SplitBlockDialog.this.blockTwoStart.setAddress(b2Start);
                length = SplitBlockDialog.this.block.getEnd().subtract(b2Start) + 1L;
                SplitBlockDialog.this.blockTwoLengthField.setValue(new Long(length));
            }
            catch (Exception e) {
                if (e instanceof AddressOverflowException) {
                    SplitBlockDialog.this.setStatusText("Could not create new start address");
                }
                return false;
            }
            return true;
        }

        private boolean blockTwoStartChanged() {
            Address start = null;
            try {
                start = this.getAddress();
            }
            catch (InvalidInputException e) {
                SplitBlockDialog.this.setStatusText("Invalid Address");
                return false;
            }
            Address end = SplitBlockDialog.this.block.getEnd();
            if (start == null) {
                return false;
            }
            if (start.compareTo((Object)end) > 0) {
                SplitBlockDialog.this.setStatusText("Start address must not be greater than end");
                return false;
            }
            if (start.compareTo((Object)SplitBlockDialog.this.block.getStart()) <= 0) {
                SplitBlockDialog.this.setStatusText("Start address must be greater than original block start (" + SplitBlockDialog.this.block.getStart() + ")");
                return false;
            }
            long length = end.subtract(start) + 1L;
            SplitBlockDialog.this.blockTwoLengthField.setValue(new Long(length));
            try {
                Address b1End = start.subtractNoWrap(1L);
                SplitBlockDialog.this.blockOneEnd.setAddress(b1End);
                length = b1End.subtract(SplitBlockDialog.this.block.getStart()) + 1L;
                SplitBlockDialog.this.blockOneLengthField.setValue(new Long(length));
            }
            catch (Exception e) {
                if (e instanceof AddressOverflowException) {
                    SplitBlockDialog.this.setStatusText("Could not create end address for split block");
                }
                return false;
            }
            return true;
        }
    }

    private class LengthChangeListener
    implements ChangeListener {
        RegisterField source;

        public LengthChangeListener(RegisterField source) {
            this.source = source;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            SplitBlockDialog.this.setStatusText("");
            boolean ok = false;
            if (this.source == SplitBlockDialog.this.blockOneLengthField) {
                ok = this.blockOneLengthChanged();
            } else if (this.source == SplitBlockDialog.this.blockTwoLengthField) {
                ok = this.blockTwoLengthChanged();
            }
            SplitBlockDialog.this.setOkEnabled(ok);
        }

        private int getLength() throws InvalidInputException {
            Long val = this.source.getValue();
            if (val == null) {
                throw new InvalidInputException();
            }
            int length = val.intValue();
            long blockSize = SplitBlockDialog.this.block.getSize();
            if (length <= 0 || (long)length >= blockSize) {
                if (length != 0) {
                    SplitBlockDialog.this.setStatusText("Length must be less than original block size (0x" + Long.toHexString(blockSize) + ")");
                }
                throw new InvalidInputException();
            }
            return length;
        }

        private boolean blockOneLengthChanged() {
            int length = 0;
            try {
                length = this.getLength();
            }
            catch (InvalidInputException e) {
                return false;
            }
            try {
                Address end = SplitBlockDialog.this.block.getStart().addNoWrap((long)(length - 1));
                Address b2Start = end.addNoWrap(1L);
                SplitBlockDialog.this.blockOneEnd.setAddress(end);
                SplitBlockDialog.this.blockTwoStart.setAddress(b2Start);
                long b2Length = SplitBlockDialog.this.block.getEnd().subtract(b2Start) + 1L;
                SplitBlockDialog.this.blockTwoLengthField.setValue(new Long(b2Length));
            }
            catch (Exception e) {
                if (e instanceof AddressOverflowException) {
                    SplitBlockDialog.this.setStatusText("Could not create new start address");
                }
                return false;
            }
            return true;
        }

        private boolean blockTwoLengthChanged() {
            int length = 0;
            try {
                length = this.getLength();
            }
            catch (InvalidInputException e) {
                return false;
            }
            try {
                Address end = SplitBlockDialog.this.block.getEnd();
                Address b2Start = end.subtractNoWrap((long)(length - 1));
                SplitBlockDialog.this.blockTwoStart.setAddress(b2Start);
                Address b1End = b2Start.subtractNoWrap(1L);
                SplitBlockDialog.this.blockOneEnd.setAddress(b1End);
                length = (int)b1End.subtract(SplitBlockDialog.this.block.getStart()) + 1;
                SplitBlockDialog.this.blockOneLengthField.setValue(new Long(length));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }
}

