/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.help;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.help.AboutDomainObjectUtils;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.main.datatable.ProjectDataActionContext;
import ghidra.framework.main.datatable.ProjectDataContextAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.util.Map;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Displays program information", description="This plugin provides an action that displays information about the currently loaded program")
public class AboutProgramPlugin
extends Plugin
implements FrontEndable {
    public static final String PLUGIN_NAME = "AboutProgramPlugin";
    public static final String ACTION_NAME = "About program";
    private DockingAction aboutAction;

    public AboutProgramPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.setupActions();
    }

    public void dispose() {
        this.tool.removeAction((DockingActionIf)this.aboutAction);
        this.aboutAction.dispose();
        super.dispose();
    }

    private void setupActions() {
        if (this.tool instanceof FrontEndTool) {
            this.aboutAction = new ProjectDataContextAction(ACTION_NAME, PLUGIN_NAME){

                protected void actionPerformed(ProjectDataActionContext context) {
                    DomainFile domainFile = (DomainFile)context.getSelectedFiles().get(0);
                    AboutProgramPlugin.this.showAbout(domainFile, domainFile.getMetadata());
                }

                protected boolean isAddToPopup(ProjectDataActionContext context) {
                    return context.getFileCount() == 1 && context.getFolderCount() == 0;
                }
            };
            this.aboutAction.setPopupMenuData(new MenuData(new String[]{"About..."}, null, "AAA"));
            this.aboutAction.setEnabled(true);
        } else {
            this.aboutAction = new ProgramContextAction(ACTION_NAME, PLUGIN_NAME){

                @Override
                public void actionPerformed(ProgramActionContext context) {
                    Program program = context.getProgram();
                    AboutProgramPlugin.this.showAbout(program.getDomainFile(), program.getMetadata());
                }

                @Override
                public boolean isEnabledForContext(ActionContext context) {
                    if (!super.isEnabledForContext(context)) {
                        this.getMenuBarData().setMenuItemName(AboutProgramPlugin.ACTION_NAME);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean isEnabledForContext(ProgramActionContext context) {
                    Program program = context.getProgram();
                    String menuName = "About " + program.getDomainFile().getName();
                    this.getMenuBarData().setMenuItemName(menuName);
                    return true;
                }
            };
            this.aboutAction.setMenuBarData(new MenuData(new String[]{"&Help", ACTION_NAME}, null, "ZZZ"));
            this.aboutAction.setEnabled(false);
        }
        this.aboutAction.setHelpLocation(new HelpLocation("About", "About_Program"));
        this.aboutAction.setDescription(this.getPluginDescription().getDescription());
        this.tool.addAction((DockingActionIf)this.aboutAction);
    }

    private void showAbout(DomainFile domainFile, Map<String, String> metadata) {
        HelpLocation helpLocation = new HelpLocation("About", "About_Program");
        AboutDomainObjectUtils.displayInformation((PluginTool)this.tool, (DomainFile)domainFile, metadata, (String)("About " + domainFile.getName()), null, (HelpLocation)helpLocation);
    }
}

