/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.combobox.GComboBox;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanelActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public abstract class FunctionChoiceComparisonPanel
extends FunctionComparisonPanel {
    private JPanel choicePanel;
    protected WrappedFunction[] leftWrappedFunctions = new WrappedFunction[0];
    protected WrappedFunction[] rightWrappedFunctions = new WrappedFunction[0];
    protected int leftIndex = 0;
    protected int rightIndex = 0;
    protected JComboBox<WrappedFunction> leftComboBox;
    protected JComboBox<WrappedFunction> rightComboBox;
    private NextFunctionAction nextFunctionAction;
    private PreviousFunctionAction previousFunctionAction;
    private static final String FUNCTION_NAVIGATE_GROUP = "A9_FunctionNavigate";
    private static final Icon FUNCTION_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/FunctionScope.gif"), -5, -2);
    private static final Icon NEXT_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/arrow_down.png"), 3, 1);
    private static final Icon PREVIOUS_ICON = new TranslateIcon((Icon)ResourceManager.loadImage((String)"images/arrow_up.png"), 3, 1);
    private static final Icon NEXT_FUNCTION_ICON = new MultiIcon(NEXT_ICON, new Icon[]{FUNCTION_ICON});
    private static final Icon PREVIOUS_FUNCTION_ICON = new MultiIcon(PREVIOUS_ICON, new Icon[]{FUNCTION_ICON});
    protected static final HelpService help = Help.getHelpService();
    protected static final String HELP_TOPIC = "FunctionComparison";
    private MyFunctionComparator myFunctionComparator = new MyFunctionComparator();

    protected FunctionChoiceComparisonPanel(ComponentProvider provider, PluginTool tool, Function leftFunction, Function rightFunction) {
        super(provider, tool, leftFunction, rightFunction);
    }

    public Function[] getLeftFunctions() {
        Function[] leftFunctions = new Function[this.leftWrappedFunctions.length];
        for (int i = 0; i < this.leftWrappedFunctions.length; ++i) {
            leftFunctions[i] = this.leftWrappedFunctions[i].getFunction();
        }
        return leftFunctions;
    }

    public Function[] getRightFunctions() {
        Function[] rightFunctions = new Function[this.rightWrappedFunctions.length];
        for (int i = 0; i < this.rightWrappedFunctions.length; ++i) {
            rightFunctions[i] = this.rightWrappedFunctions[i].getFunction();
        }
        return rightFunctions;
    }

    protected WrappedFunction[] getWrappedFunctions(Function[] functionArray) {
        WrappedFunction[] wrappedFunctionArray = new WrappedFunction[functionArray.length];
        for (int i = 0; i < functionArray.length; ++i) {
            wrappedFunctionArray[i] = new WrappedFunction(functionArray[i]);
        }
        return wrappedFunctionArray;
    }

    protected void addChoicePanel() {
        this.choicePanel = new JPanel(new GridLayout(1, 2));
        this.choicePanel.add(this.createLeftChoicePanel());
        this.choicePanel.add(this.createRightChoicePanel());
        this.add((Component)this.choicePanel, "North");
        help.registerHelp((Object)this.choicePanel, new HelpLocation(HELP_TOPIC, "Compare Multiple Functions"));
    }

    protected void adjustSelectedLeftFunction() {
        WrappedFunction leftWrappedFunction = this.leftIndex < this.leftWrappedFunctions.length ? this.leftWrappedFunctions[this.leftIndex] : null;
        this.leftComboBox.setSelectedItem(leftWrappedFunction);
    }

    protected void adjustSelectedRightFunction() {
        WrappedFunction rightWrappedFunction = this.rightIndex < this.rightWrappedFunctions.length ? this.rightWrappedFunctions[this.rightIndex] : null;
        this.rightComboBox.setSelectedItem(rightWrappedFunction);
    }

    private Component createLeftChoicePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.leftComboBox = new GComboBox((Object[])this.leftWrappedFunctions);
        this.adjustSelectedLeftFunction();
        this.leftComboBox.addItemListener(e -> {
            WrappedFunction wrappedFunction = (WrappedFunction)this.leftComboBox.getSelectedItem();
            Function function = wrappedFunction != null ? wrappedFunction.getFunction() : null;
            this.setLeftFunction(function);
        });
        panel.add(this.leftComboBox, "Center");
        return panel;
    }

    private Component createRightChoicePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.rightComboBox = new GComboBox((Object[])this.rightWrappedFunctions);
        this.adjustSelectedRightFunction();
        this.rightComboBox.addItemListener(e -> {
            WrappedFunction wrappedFunction = (WrappedFunction)this.rightComboBox.getSelectedItem();
            Function function = wrappedFunction != null ? wrappedFunction.getFunction() : null;
            this.setRightFunction(function);
        });
        panel.add(this.rightComboBox, "Center");
        return panel;
    }

    protected void createActions() {
        if (this.choicePanel != null) {
            this.nextFunctionAction = new NextFunctionAction();
            this.previousFunctionAction = new PreviousFunctionAction();
        }
    }

    @Override
    public DockingAction[] getCodeComparisonActions() {
        DockingAction[] otherActions = super.getCodeComparisonActions();
        if (this.choicePanel == null) {
            return otherActions;
        }
        DockingAction[] myActions = new DockingAction[]{this.nextFunctionAction, this.previousFunctionAction};
        DockingAction[] actions = new DockingAction[otherActions.length + myActions.length];
        System.arraycopy(otherActions, 0, actions, 0, otherActions.length);
        System.arraycopy(myActions, 0, actions, otherActions.length, myActions.length);
        return actions;
    }

    private boolean isValidPanelContext(ActionContext context) {
        if (context instanceof CodeComparisonPanelActionContext) {
            return this.choicePanel != null;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void nextFunction() {
        CodeComparisonPanel<? extends FieldPanelCoordinator> currentComponent = this.getCurrentComponent();
        if (currentComponent == null) {
            return;
        }
        boolean leftHasFocus = currentComponent.leftPanelHasFocus();
        if (leftHasFocus) {
            if (this.leftIndex < this.leftWrappedFunctions.length - 1) {
                this.leftComboBox.setSelectedIndex(++this.leftIndex);
                return;
            }
            this.outputNoNextPreviousMessage(true, leftHasFocus);
            return;
        }
        if (this.rightIndex < this.rightWrappedFunctions.length - 1) {
            this.rightComboBox.setSelectedIndex(++this.rightIndex);
            return;
        }
        this.outputNoNextPreviousMessage(true, leftHasFocus);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void previousFunction() {
        CodeComparisonPanel<? extends FieldPanelCoordinator> currentComponent = this.getCurrentComponent();
        if (currentComponent == null) {
            return;
        }
        boolean leftHasFocus = currentComponent.leftPanelHasFocus();
        if (leftHasFocus) {
            if (this.leftIndex > 0) {
                this.leftComboBox.setSelectedIndex(--this.leftIndex);
                return;
            }
            this.outputNoNextPreviousMessage(false, leftHasFocus);
            return;
        }
        if (this.rightIndex > 0) {
            this.rightComboBox.setSelectedIndex(--this.rightIndex);
            return;
        }
        this.outputNoNextPreviousMessage(false, leftHasFocus);
    }

    private void outputNoNextPreviousMessage(boolean forward, boolean isFirstListing) {
        this.tool.setStatusInfo("There isn't another " + (forward ? "next " : "previous ") + "function for the " + (isFirstListing ? "first" : "second") + " listing.");
    }

    protected Function[] getSortedFunctions(Set<Function> functions) {
        Function[] sortedFunctions = functions.toArray(new Function[functions.size()]);
        Arrays.sort(sortedFunctions, this.myFunctionComparator);
        return sortedFunctions;
    }

    protected Function[] getSortedFunctions(Function[] functions) {
        Function[] sortedFunctions = Arrays.copyOf(functions, functions.length);
        Arrays.sort(sortedFunctions, this.myFunctionComparator);
        return sortedFunctions;
    }

    protected static class WrappedFunction {
        private Function function;

        private WrappedFunction(Function function) {
            this.function = function;
        }

        protected Function getFunction() {
            return this.function;
        }

        public String toString() {
            return this.getFunctionTitle();
        }

        private String getFunctionTitle() {
            if (this.function == null) {
                return "none";
            }
            Program program = this.function.getProgram();
            return this.function.getName(true) + "()" + (String)(program != null ? " in " + program.getDomainFile().getPathname() : "");
        }
    }

    private class MyFunctionComparator
    implements Comparator<Function> {
        private MyFunctionComparator() {
        }

        @Override
        public int compare(Function function1, Function function2) {
            String program2Name;
            if (function1 == null) {
                if (function2 == null) {
                    return 0;
                }
                return -1;
            }
            if (function1 == function2) {
                return 0;
            }
            String function1Name = function1.getName(true);
            String function2Name = function2.getName(true);
            Program program1 = function1.getProgram();
            Program program2 = function2.getProgram();
            String program1Name = program1.getDomainFile().getPathname();
            int comparePrograms = program1Name.compareTo(program2Name = program2.getDomainFile().getPathname());
            if (comparePrograms != 0) {
                return comparePrograms;
            }
            return function1Name.compareTo(function2Name);
        }
    }

    protected class PreviousFunctionAction
    extends DockingAction {
        PreviousFunctionAction() {
            super("Compare Previous Function", FunctionChoiceComparisonPanel.this.provider.getOwner());
            this.setKeyBindingData(new KeyBindingData('P', 3));
            this.setDescription("Compare the previous function for the side with focus.");
            this.setPopupMenuData(new MenuData(new String[]{"Compare The Previous Function"}, PREVIOUS_FUNCTION_ICON, FunctionChoiceComparisonPanel.FUNCTION_NAVIGATE_GROUP));
            ToolBarData newToolBarData = new ToolBarData(PREVIOUS_FUNCTION_ICON, FunctionChoiceComparisonPanel.FUNCTION_NAVIGATE_GROUP);
            this.setToolBarData(newToolBarData);
            HelpLocation helpLocation = new HelpLocation(FunctionChoiceComparisonPanel.HELP_TOPIC, "Compare The Previous Function");
            this.setHelpLocation(helpLocation);
            this.setEnabled(true);
        }

        public boolean isValidContext(ActionContext context) {
            return FunctionChoiceComparisonPanel.this.isValidPanelContext(context);
        }

        public void actionPerformed(ActionContext context) {
            if (this.isValidContext(context)) {
                FunctionChoiceComparisonPanel.this.previousFunction();
            }
        }
    }

    protected class NextFunctionAction
    extends DockingAction {
        NextFunctionAction() {
            super("Compare Next Function", FunctionChoiceComparisonPanel.this.provider.getOwner());
            this.setKeyBindingData(new KeyBindingData('N', 3));
            this.setDescription("Compare the next function for the side with focus.");
            this.setPopupMenuData(new MenuData(new String[]{"Compare The Next Function"}, NEXT_FUNCTION_ICON, FunctionChoiceComparisonPanel.FUNCTION_NAVIGATE_GROUP));
            ToolBarData newToolBarData = new ToolBarData(NEXT_FUNCTION_ICON, FunctionChoiceComparisonPanel.FUNCTION_NAVIGATE_GROUP);
            this.setToolBarData(newToolBarData);
            HelpLocation helpLocation = new HelpLocation(FunctionChoiceComparisonPanel.HELP_TOPIC, "Compare The Next Function");
            this.setHelpLocation(helpLocation);
            this.setEnabled(true);
        }

        public boolean isValidContext(ActionContext context) {
            return FunctionChoiceComparisonPanel.this.isValidPanelContext(context);
        }

        public void actionPerformed(ActionContext context) {
            if (this.isValidContext(context)) {
                FunctionChoiceComparisonPanel.this.nextFunction();
            }
        }
    }
}

