/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Compute Checksums", description="Computes a variety of checksums algorithms on a file.")
public class ComputeChecksumsPlugin
extends ProgramPlugin {
    static final String DESCRIPTION = "Computes a variety of checksums algorithms on a file.";
    private ComputeChecksumsProvider provider;
    private DockingAction action;

    public ComputeChecksumsPlugin(PluginTool tool) {
        super(tool, true, true);
        this.createActions();
        this.provider = new ComputeChecksumsProvider(this);
    }

    protected void dispose() {
        this.provider.dispose();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    private void createActions() {
        this.action = new DockingAction("GenerateChecksum", this.getName()){

            public void actionPerformed(ActionContext context) {
                ComputeChecksumsPlugin.this.openProvider();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return true;
            }
        };
        this.action.setEnabled(true);
        this.action.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "Generate_Checksum_Help"));
        this.action.setMenuBarData(new MenuData(new String[]{"&Tools", "Generate Checksum..."}));
        this.action.setDescription(DESCRIPTION);
        this.tool.addAction((DockingActionIf)this.action);
    }

    private void openProvider() {
        if (this.provider.isVisible()) {
            this.provider.toFront();
        } else {
            this.provider.setVisible(true);
        }
        this.provider.setSelection(this.currentSelection != null && !this.currentSelection.isEmpty());
    }

    DockingAction getAction() {
        return this.action;
    }

    @Override
    protected void selectionChanged(ProgramSelection selection) {
        this.provider.setSelection(this.hasSelection());
    }

    ProgramSelection getSelection() {
        return this.currentSelection;
    }

    boolean hasSelection() {
        ProgramSelection selection = this.getSelection();
        return selection != null && !selection.isEmpty();
    }
}

