/*
 * Decompiled with CFR 0.152.
 */
package generic.algorithms;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class Lcs<T> {
    private static int DEFAULT_SIZE_LIMIT = 1000000;
    private int sizeLimit = DEFAULT_SIZE_LIMIT;
    private int[][] c;

    protected abstract int lengthOfX();

    protected abstract int lengthOfY();

    protected abstract T valueOfX(int var1);

    protected abstract T valueOfY(int var1);

    protected abstract boolean matches(T var1, T var2);

    private void calculateLCS(TaskMonitor monitor) throws CancelledException {
        int i;
        if (this.c != null) {
            return;
        }
        if (this.tooBig()) {
            this.c = new int[0][0];
            return;
        }
        int[][] tempC = new int[this.lengthOfX() + 1][];
        monitor.setMessage("Calculating LCS...");
        monitor.initialize((long)tempC.length);
        for (i = 0; i < tempC.length; ++i) {
            tempC[i] = new int[this.lengthOfY() + 1];
        }
        for (i = 1; i < tempC.length; ++i) {
            monitor.checkCanceled();
            for (int j = 1; j < tempC[i].length; ++j) {
                tempC[i][j] = this.matches(this.valueOfX(i), this.valueOfY(j)) ? tempC[i - 1][j - 1] + 1 : Math.max(tempC[i][j - 1], tempC[i - 1][j]);
            }
            monitor.incrementProgress(1L);
        }
        this.c = tempC;
    }

    private boolean tooBig() {
        return this.lengthOfX() * this.lengthOfY() > this.sizeLimit;
    }

    public void setSizeLimit(int newLimit) {
        this.sizeLimit = newLimit;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public List<T> getLcs() {
        try {
            return this.getLcs(TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public List<T> getLcs(TaskMonitor monitor) throws CancelledException {
        this.calculateLCS(monitor);
        return this.doGetLcs(monitor);
    }

    protected List<T> doGetLcs(TaskMonitor monitor) throws CancelledException {
        int x = 0;
        int y = 0;
        if (this.c.length > 0) {
            x = this.lengthOfX();
            y = this.lengthOfY();
        }
        ArrayList<T> result = new ArrayList<T>();
        while (x > 0 && y > 0) {
            monitor.checkCanceled();
            if (this.c[x][y] == this.c[x - 1][y - 1] + 1 && this.matches(this.valueOfX(x), this.valueOfY(y))) {
                result.add(0, this.valueOfX(x));
                --x;
                --y;
                continue;
            }
            if (this.c[x][y] == this.c[x - 1][y]) {
                --x;
                continue;
            }
            --y;
        }
        return result;
    }
}

