/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.label.GDHtmlLabel;
import docking.widgets.numberformat.BoundedRangeDecimalFormatterFactory;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.RangeColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import ghidra.util.layout.VerticalLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DoubleRangeConstraintEditor
extends AbstractColumnConstraintEditor<Double> {
    public static final String FLOATING_POINT_FORMAT = "0.##########;-0.##########";
    public static final String DISPLAY_FORMAT = "#,##0.##########;-#,##0.##########";
    private JSpinner lowerSpinner;
    private JSpinner upperSpinner;
    private JLabel infoLabel;
    private NumberFormat infoLabelNumberFormat;
    private String errorMessage;

    public DoubleRangeConstraintEditor(ColumnConstraint<Double> constraint) {
        super(constraint);
    }

    @Override
    protected Component buildInlineEditorComponent() {
        double minValue = this.getConstraint().getMinValue();
        double maxValue = this.getConstraint().getMaxValue();
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(2));
        this.lowerSpinner = this.createSpinner(minValue);
        this.upperSpinner = this.createSpinner(maxValue);
        this.lowerSpinner.setName("double.lower.spinner");
        this.upperSpinner.setName("double.upper.spinner");
        JPanel rangeControlPanel = new JPanel(new GridLayout(1, 2));
        rangeControlPanel.add(this.lowerSpinner);
        rangeControlPanel.add(this.upperSpinner);
        panel.add(rangeControlPanel);
        this.infoLabelNumberFormat = new DecimalFormat(DISPLAY_FORMAT);
        this.infoLabel = new GDHtmlLabel();
        this.infoLabel.setHorizontalAlignment(0);
        panel.add(this.infoLabel);
        return panel;
    }

    private JSpinner createSpinner(Number value) {
        Double stepSize = new Double(0.1);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(value, null, null, stepSize);
        final JSpinner spinner = new JSpinner(spinnerModel);
        JSpinner.NumberEditor numEditor = (JSpinner.NumberEditor)spinner.getEditor();
        final JFormattedTextField textField = numEditor.getTextField();
        textField.setHorizontalAlignment(4);
        textField.setValue(value);
        textField.setFormatterFactory(new BoundedRangeDecimalFormatterFactory(FLOATING_POINT_FORMAT));
        textField.setName("editor");
        textField.setColumns(12);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DoubleRangeConstraintEditor.this.textChanged(spinner, textField);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DoubleRangeConstraintEditor.this.textChanged(spinner, textField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DoubleRangeConstraintEditor.this.textChanged(spinner, textField);
            }
        });
        spinner.addMouseWheelListener(e -> {
            Number val = (Number)spinner.getValue();
            try {
                double step = spinnerModel.getStepSize().doubleValue();
                if (e.getWheelRotation() > 0) {
                    spinner.setValue(DoubleRangeConstraintEditor.decrement(val, step));
                } else {
                    spinner.setValue(DoubleRangeConstraintEditor.increment(val, step));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        spinnerModel.addChangeListener(e -> this.valueChanged());
        return spinner;
    }

    private void textChanged(JSpinner spinner, JTextField textField) {
        SwingUtilities.invokeLater(() -> {
            try {
                int caretPosition = textField.getCaretPosition();
                int length = textField.getText().length();
                int fromEnd = length - caretPosition;
                spinner.commitEdit();
                length = textField.getText().length();
                textField.setCaretPosition(Math.max(length - fromEnd, 0));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.valueChanged();
        });
    }

    private static Number increment(Number base, Number by) {
        if (base instanceof Byte || base instanceof Short || base instanceof Integer || base instanceof Long) {
            return base.longValue() + by.longValue();
        }
        return base.doubleValue() + by.doubleValue();
    }

    private static Number decrement(Number base, Number by) {
        if (base instanceof Byte || base instanceof Short || base instanceof Integer || base instanceof Long) {
            return base.longValue() - by.longValue();
        }
        return base.doubleValue() - by.doubleValue();
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        if (isValid) {
            Number start = (Number)this.lowerSpinner.getValue();
            Number end = (Number)this.upperSpinner.getValue();
            double dblStart = start.doubleValue();
            double dblEnd = end.doubleValue();
            double delta = dblEnd - dblStart + 1.0;
            String message = String.format("Range size: %s", this.infoLabelNumberFormat.format(delta));
            this.infoLabel.setText(DoubleRangeConstraintEditor.formatStatus(message, false));
        } else {
            this.infoLabel.setText(DoubleRangeConstraintEditor.formatStatus(this.getErrorMessage(), true));
        }
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            double minValue = this.getConstraint().getMinValue();
            double maxValue = this.getConstraint().getMaxValue();
            this.lowerSpinner.setValue(minValue);
            this.upperSpinner.setValue(maxValue);
        }
        this.valueChanged();
    }

    @Override
    public void reset() {
        this.setValue(this.getConstraint().copy(0.0, 0.0));
    }

    @Override
    protected ColumnConstraint<Double> getValueFromComponent() {
        double lowerValue = (Double)this.lowerSpinner.getValue();
        double upperValue = (Double)this.upperSpinner.getValue();
        return this.getConstraint().copy(lowerValue, upperValue);
    }

    @Override
    protected boolean checkEditorValueValidity() {
        double uVal;
        boolean isValidLower = this.hasValidValue(this.lowerSpinner);
        boolean isValidUpper = this.hasValidValue(this.upperSpinner);
        DoubleRangeConstraintEditor.markSpinnerAsValid(this.lowerSpinner, isValidLower);
        DoubleRangeConstraintEditor.markSpinnerAsValid(this.upperSpinner, isValidUpper);
        this.errorMessage = "";
        if (!isValidLower && !isValidUpper) {
            this.errorMessage = "Invalid lower and upper bounds!";
            return false;
        }
        if (!isValidLower) {
            this.errorMessage = "Invalid lower bounds!";
            return false;
        }
        if (!isValidUpper) {
            this.errorMessage = "Invalid upper bounds!";
            return false;
        }
        double lVal = (Double)this.lowerSpinner.getValue();
        if (lVal > (uVal = ((Double)this.upperSpinner.getValue()).doubleValue())) {
            this.errorMessage = "Upper bounds value must be greater than lower bounds!";
            return false;
        }
        return true;
    }

    private boolean hasValidValue(JSpinner spinner) {
        JSpinner.NumberEditor numEditor = (JSpinner.NumberEditor)spinner.getEditor();
        JFormattedTextField textField = numEditor.getTextField();
        JFormattedTextField.AbstractFormatter formatter = textField.getFormatter();
        String text = textField.getText();
        try {
            String roundTrip = formatter.valueToString(formatter.stringToValue(text));
            Double textDouble = Double.valueOf(text);
            Double roundTripDouble = Double.valueOf(roundTrip);
            return Double.compare(textDouble, roundTripDouble) == 0;
        }
        catch (ParseException e) {
            return false;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static void markSpinnerAsValid(JSpinner spinner, boolean valid) {
        JSpinner.NumberEditor numEditor = (JSpinner.NumberEditor)spinner.getEditor();
        JFormattedTextField textField = numEditor.getTextField();
        textField.setBackground(valid ? VALID_INPUT_COLOR : INVALID_INPUT_COLOR);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private RangeColumnConstraint<Double> getConstraint() {
        return (RangeColumnConstraint)this.currentConstraint;
    }

    JSpinner getLowerSpinner() {
        return this.lowerSpinner;
    }

    JSpinner getUpperSpinner() {
        return this.upperSpinner;
    }
}

