/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnConstraintSet;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.dialog.ColumnFilterData;
import docking.widgets.table.constraint.dialog.DialogFilterRow;
import docking.widgets.table.constraint.dialog.TableFilterDialogModelListener;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnFilterDialogModel<R> {
    private RowObjectFilterModel<R> tableModel;
    private List<ColumnFilterData<?>> allFilters = new ArrayList();
    private List<DialogFilterRow> filterRows = new ArrayList<DialogFilterRow>();
    private WeakSet<TableFilterDialogModelListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private TableColumnModel columnModel;
    private TableColumnModelListener columnModelListener = new MyTableColumnModelListener();
    private ColumnBasedTableFilter<R> currentFilter;
    private ColumnBasedTableFilter<R> defaultFilter;

    public ColumnFilterDialogModel(RowObjectFilterModel<R> model, TableColumnModel columnModel, ColumnBasedTableFilter<R> currentColumnTableFilter) {
        this.tableModel = model;
        this.columnModel = columnModel;
        this.currentFilter = currentColumnTableFilter;
        columnModel.addColumnModelListener(this.columnModelListener);
        int columnCount = columnModel.getColumnCount();
        for (int viewIndex = 0; viewIndex < columnCount; ++viewIndex) {
            Class<?> columnClass;
            int modelIndex = columnModel.getColumn(viewIndex).getModelIndex();
            ColumnFilterData<?> columnData = this.createColumnFilterData(modelIndex, viewIndex, columnClass = model.getColumnClass(modelIndex));
            if (!columnData.isFilterable()) continue;
            this.allFilters.add(columnData);
        }
        this.addEntriesFromCurrentTableFilter(currentColumnTableFilter);
        if (this.filterRows.isEmpty()) {
            this.createFilterRow(LogicOperation.AND);
            this.defaultFilter = this.getTableColumnFilter();
        }
    }

    public void dispose() {
        this.columnModel.removeColumnModelListener(this.columnModelListener);
    }

    public DialogFilterRow createFilterRow(LogicOperation logicOperation) {
        DialogFilterRow filterRow = new DialogFilterRow(this, logicOperation);
        this.filterRows.add(filterRow);
        this.notifyFilterChanged();
        return filterRow;
    }

    public void deleteFilterRow(DialogFilterRow filterRow) {
        this.filterRows.remove(filterRow);
        this.notifyFilterChanged();
    }

    public List<DialogFilterRow> getFilterRows() {
        return this.filterRows;
    }

    public void addListener(TableFilterDialogModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(TableFilterDialogModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean isValid() {
        for (DialogFilterRow filterRow : this.filterRows) {
            if (filterRow.hasValidFilterValue()) continue;
            return false;
        }
        return true;
    }

    void dialogFilterRowChanged(DialogFilterRow filterRow) {
        this.notifyFilterChanged();
    }

    void editorValueChanged(ColumnConstraintEditor<?> editor) {
        for (TableFilterDialogModelListener listener : this.listeners) {
            listener.editorValueChanged(editor);
        }
    }

    Object getDataSource() {
        if (this.tableModel instanceof GDynamicColumnTableModel) {
            return ((GDynamicColumnTableModel)((Object)this.tableModel)).getDataSource();
        }
        return null;
    }

    public ColumnBasedTableFilter<R> getTableColumnFilter() {
        if (!this.isValid()) {
            return null;
        }
        if (this.filterRows.isEmpty()) {
            return null;
        }
        ColumnBasedTableFilter<R> tableColumnFilter = new ColumnBasedTableFilter<R>(this.tableModel);
        for (DialogFilterRow filterRow : this.filterRows) {
            filterRow.addToTableFilter(tableColumnFilter);
        }
        if (tableColumnFilter.isEquivalent(this.currentFilter)) {
            return this.currentFilter;
        }
        return tableColumnFilter;
    }

    void setFilter(ColumnBasedTableFilter<R> filter) {
        this.filterRows.clear();
        this.addEntriesFromCurrentTableFilter(filter);
        this.currentFilter = filter;
        this.notifyFilterChanged();
    }

    public void clear() {
        ArrayList<DialogFilterRow> temp = new ArrayList<DialogFilterRow>(this.filterRows);
        for (DialogFilterRow filterRow : temp) {
            this.deleteFilterRow(filterRow);
        }
    }

    public List<ColumnFilterData<?>> getAllColumnFilterData() {
        return this.allFilters;
    }

    public boolean isEmpty() {
        return this.filterRows.isEmpty();
    }

    public boolean hasUnappliedChanges() {
        ColumnBasedTableFilter<R> tableColumnFilter = this.getTableColumnFilter();
        if (tableColumnFilter == null) {
            return this.currentFilter != null;
        }
        if (tableColumnFilter.isEquivalent(this.defaultFilter)) {
            return false;
        }
        return !tableColumnFilter.isEquivalent(this.currentFilter);
    }

    RowObjectFilterModel<?> getTableModel() {
        return this.tableModel;
    }

    private ColumnFilterData<?> createColumnFilterData(int modelIndex, int viewIndex, Class<?> columnClass) {
        return new ColumnFilterData(this.tableModel, modelIndex, viewIndex, columnClass);
    }

    private void addEntriesFromCurrentTableFilter(ColumnBasedTableFilter<R> columnTableFilter) {
        if (columnTableFilter == null) {
            return;
        }
        List<ColumnConstraintSet<R, ?>> columnFilters = columnTableFilter.getConstraintSets();
        for (ColumnConstraintSet<R, ?> columnFilter : columnFilters) {
            if (!this.hasColumnFilterData(columnFilter)) continue;
            DialogFilterRow filterRow = new DialogFilterRow(this, columnFilter);
            this.filterRows.add(filterRow);
        }
    }

    private boolean hasColumnFilterData(ColumnConstraintSet<R, ?> columnFilter) {
        ColumnFilterData<?> data = this.getColumnFilterDataByModelIndex(columnFilter.getColumnModelIndex());
        return data != null;
    }

    private ColumnFilterData<?> getColumnFilterDataByModelIndex(int columnModelIndex) {
        for (ColumnFilterData<?> columnFilterData : this.allFilters) {
            if (columnFilterData.getColumnModelIndex() != columnModelIndex) continue;
            return columnFilterData;
        }
        return null;
    }

    private ColumnFilterData<?> getColumnFilterDataByViewIndex(int viewIndex) {
        for (ColumnFilterData<?> columnFilterData : this.allFilters) {
            if (columnFilterData.getViewIndex() != viewIndex) continue;
            return columnFilterData;
        }
        return null;
    }

    private DialogFilterRow getFilterRowForColumnData(ColumnFilterData<?> columnFilterData) {
        for (DialogFilterRow filterRow : this.filterRows) {
            if (!filterRow.getColumnFilterData().equals(columnFilterData)) continue;
            return filterRow;
        }
        return null;
    }

    private void notifyFilterChanged() {
        for (TableFilterDialogModelListener listener : this.listeners) {
            listener.structureChanged();
        }
    }

    private void updateColumnViewIndices() {
        for (int viewIndex = 0; viewIndex < this.columnModel.getColumnCount(); ++viewIndex) {
            TableColumn column = this.columnModel.getColumn(viewIndex);
            int modelIndex = column.getModelIndex();
            ColumnFilterData<?> columnFilterData = this.getColumnFilterDataByModelIndex(modelIndex);
            if (columnFilterData == null) continue;
            columnFilterData.setViewIndex(viewIndex);
        }
        Collections.sort(this.allFilters, (o1, o2) -> o1.getViewIndex() - o2.getViewIndex());
    }

    public void setCurrentlyAppliedFilter(ColumnBasedTableFilter<R> tableColumnFilter) {
        this.currentFilter = tableColumnFilter;
    }

    private class MyTableColumnModelListener
    implements TableColumnModelListener {
        private MyTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            Class<?> columnClass;
            int viewIndex = e.getToIndex();
            TableColumn column = ColumnFilterDialogModel.this.columnModel.getColumn(viewIndex);
            int modelIndex = column.getModelIndex();
            ColumnFilterData<?> columnFilterData = ColumnFilterDialogModel.this.createColumnFilterData(modelIndex, viewIndex, columnClass = ColumnFilterDialogModel.this.tableModel.getColumnClass(modelIndex));
            if (columnFilterData.isFilterable()) {
                ColumnFilterDialogModel.this.allFilters.add(columnFilterData);
            }
            ColumnFilterDialogModel.this.updateColumnViewIndices();
            ColumnFilterDialogModel.this.notifyFilterChanged();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            int viewIndex = e.getFromIndex();
            ColumnFilterData<?> columnFilterData = ColumnFilterDialogModel.this.getColumnFilterDataByViewIndex(viewIndex);
            ColumnFilterDialogModel.this.allFilters.remove(columnFilterData);
            DialogFilterRow filterRow = ColumnFilterDialogModel.this.getFilterRowForColumnData(columnFilterData);
            if (filterRow != null) {
                ColumnFilterDialogModel.this.deleteFilterRow(filterRow);
            }
            ColumnFilterDialogModel.this.updateColumnViewIndices();
            ColumnFilterDialogModel.this.notifyFilterChanged();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() == e.getToIndex()) {
                return;
            }
            ColumnFilterDialogModel.this.updateColumnViewIndices();
            ColumnFilterDialogModel.this.notifyFilterChanged();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

