/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import ghidra.framework.options.SaveState;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class FieldSelection
implements Iterable<FieldRange> {
    private List<FieldRange> ranges;

    public FieldSelection() {
        this.ranges = new ArrayList<FieldRange>(4);
    }

    public FieldSelection(FieldSelection selection) {
        this.ranges = new ArrayList<FieldRange>(selection.ranges.size());
        for (FieldRange range : selection.ranges) {
            this.ranges.add(new FieldRange(range));
        }
    }

    public void clear() {
        this.ranges = new ArrayList<FieldRange>(4);
    }

    public boolean contains(FieldLocation loc) {
        return this.getRangeContaining(loc) != null;
    }

    public FieldRange getRangeContaining(FieldLocation loc) {
        int insertIndex = Collections.binarySearch(this.ranges, new FieldRange(loc, FieldLocation.MAX));
        if (insertIndex >= 0) {
            return this.ranges.get(insertIndex);
        }
        int compareIndex = -insertIndex - 2;
        if (compareIndex < 0) {
            return null;
        }
        FieldRange compareRange = this.ranges.get(compareIndex);
        if (compareRange.contains(loc)) {
            return compareRange;
        }
        return null;
    }

    public boolean containsEntirely(BigInteger index) {
        FieldLocation start = new FieldLocation(index, 0, 0, 0);
        FieldLocation end = new FieldLocation(index.add(BigInteger.ONE), 0, 0, 0);
        return this.containsEntirely(new FieldRange(start, end));
    }

    public boolean containsEntirely(FieldRange range) {
        FieldRange rangeContaining = this.getRangeContaining(range.start);
        if (rangeContaining == null) {
            return false;
        }
        return range.end.compareTo(rangeContaining.end) <= 0;
    }

    public boolean excludesEntirely(FieldRange range) {
        int searchIndex = Collections.binarySearch(this.ranges, range);
        if (searchIndex >= 0) {
            return false;
        }
        if ((searchIndex = -searchIndex - 2) >= 0 && this.ranges.get(searchIndex).intersects(range)) {
            return false;
        }
        if (++searchIndex < this.ranges.size()) {
            return !this.ranges.get(searchIndex).intersects(range);
        }
        return true;
    }

    public boolean excludesEntirely(BigInteger index) {
        FieldLocation start = new FieldLocation(index, 0, 0, 0);
        FieldLocation end = new FieldLocation(index.add(BigInteger.ONE), 0, 0, 0);
        return this.excludesEntirely(new FieldRange(start, end));
    }

    public void addRange(FieldLocation start, FieldLocation end) {
        if (start.equals(end)) {
            return;
        }
        FieldRange newRange = new FieldRange(start, end);
        int insertIndex = Collections.binarySearch(this.ranges, newRange);
        if (insertIndex >= 0) {
            return;
        }
        if ((insertIndex = -insertIndex - 2) >= 0 && this.ranges.get(insertIndex).canMerge(newRange)) {
            this.ranges.get(insertIndex).merge(newRange);
        } else {
            this.ranges.add(++insertIndex, newRange);
        }
        FieldRange currentRange = this.ranges.get(insertIndex);
        int checkIndex = insertIndex + 1;
        while (checkIndex < this.ranges.size() && currentRange.canMerge(this.ranges.get(checkIndex))) {
            currentRange.merge(this.ranges.get(checkIndex));
            this.ranges.remove(checkIndex);
        }
    }

    public void addRange(int startIndex, int endIndex) {
        this.addRange(new FieldLocation(startIndex, 0, 0, 0), new FieldLocation(endIndex, 0, 0, 0));
    }

    public void addRange(BigInteger startIndex, BigInteger endIndex) {
        this.addRange(new FieldLocation(startIndex, 0, 0, 0), new FieldLocation(endIndex, 0, 0, 0));
    }

    public void addRange(int startIndex, int startFieldNum, int endIndex, int endFieldNum) {
        this.addRange(new FieldLocation(startIndex, startFieldNum, 0, 0), new FieldLocation(endIndex, endFieldNum, 0, 0));
    }

    public void addRange(BigInteger startIndex, int startFieldNum, BigInteger endIndex, int endFieldNum) {
        this.addRange(new FieldLocation(startIndex, startFieldNum, 0, 0), new FieldLocation(endIndex, endFieldNum, 0, 0));
    }

    public void removeRange(FieldLocation start, FieldLocation end) {
        FieldRange leftOver;
        FieldRange range;
        FieldRange deleteRange = new FieldRange(start, end);
        int insertIndex = Collections.binarySearch(this.ranges, deleteRange);
        if (insertIndex >= 0) {
            this.ranges.remove(insertIndex);
            return;
        }
        if ((insertIndex = -insertIndex - 2) >= 0 && deleteRange.intersects(range = this.ranges.get(insertIndex))) {
            leftOver = range.subtract(deleteRange);
            if (range.isEmpty()) {
                this.ranges.remove(insertIndex);
                --insertIndex;
            } else if (leftOver != null) {
                this.ranges.add(insertIndex + 1, leftOver);
                return;
            }
        }
        ++insertIndex;
        while (insertIndex < this.ranges.size()) {
            range = this.ranges.get(insertIndex);
            if (!deleteRange.intersects(range)) {
                return;
            }
            leftOver = range.subtract(deleteRange);
            if (range.isEmpty()) {
                this.ranges.remove(insertIndex);
                continue;
            }
            if (leftOver != null) {
                this.ranges.add(insertIndex + 1, leftOver);
                return;
            }
            return;
        }
    }

    public void removeRange(int startIndex, int endIndex) {
        this.removeRange(new FieldLocation(startIndex, 0, 0, 0), new FieldLocation(endIndex, 0, 0, 0));
    }

    public void removeRange(BigInteger startIndex, BigInteger endIndex) {
        this.removeRange(new FieldLocation(startIndex, 0, 0, 0), new FieldLocation(endIndex, 0, 0, 0));
    }

    public int getNumRanges() {
        return this.ranges.size();
    }

    public FieldRange getFieldRange(int rangeNum) {
        return this.ranges.get(rangeNum);
    }

    public final void intersect(FieldSelection selection) {
        if (selection == null || this.ranges.size() == 0 || selection.ranges.size() == 0) {
            this.clear();
            return;
        }
        FieldSelection A = this;
        FieldSelection B = selection;
        FieldSelection C = new FieldSelection(this);
        C.delete(B);
        A.delete(C);
    }

    public final FieldSelection findIntersection(FieldSelection selection) {
        if (selection == null || this.ranges.size() == 0 || selection.ranges.size() == 0) {
            return new FieldSelection();
        }
        FieldSelection A = new FieldSelection(this);
        FieldSelection B = selection;
        FieldSelection C = new FieldSelection(this);
        C.delete(B);
        A.delete(C);
        return A;
    }

    public final void delete(FieldSelection selection) {
        if (selection == null || this.ranges.size() == 0 || selection.ranges.size() == 0) {
            return;
        }
        for (FieldRange range : selection.ranges) {
            this.removeRange(range.start, range.end);
        }
    }

    public final void insert(FieldSelection selection) {
        if (selection == null || selection.getNumRanges() == 0) {
            return;
        }
        for (FieldRange range : selection.ranges) {
            this.addRange(range.start, range.end);
        }
    }

    public void printRanges() {
        Msg.debug((Object)this, (Object)"*********");
        for (FieldRange range : this.ranges) {
            Msg.debug((Object)this, (Object)range);
        }
        Msg.debug((Object)this, (Object)"**********");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (FieldRange range : this.ranges) {
            buf.append(range.toString());
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldSelection)) {
            return false;
        }
        FieldSelection other = (FieldSelection)obj;
        if (this.ranges.size() != other.ranges.size()) {
            return false;
        }
        int n = this.ranges.size();
        for (int i = 0; i < n; ++i) {
            FieldRange otherRange;
            FieldRange thisRange = this.ranges.get(i);
            if (thisRange.equals(otherRange = other.ranges.get(i))) continue;
            return false;
        }
        return true;
    }

    public void save(SaveState saveState) {
        if (this.ranges.isEmpty()) {
            return;
        }
        Element listElement = new Element("FIELD_RANGES");
        for (FieldRange range : this.ranges) {
            Element element = range.getElement();
            listElement.addContent((Content)element);
        }
        saveState.putXmlElement("FIELD_SELECTION", listElement);
    }

    public void load(SaveState saveState) {
        this.clear();
        Element element = saveState.getXmlElement("FIELD_SELECTION");
        if (element != null) {
            List children = element.getChildren();
            for (Object object : children) {
                Element child = (Element)object;
                this.ranges.add(new FieldRange(child));
            }
        }
    }

    public boolean isEmpty() {
        return this.ranges.size() == 0;
    }

    public FieldSelection intersect(int index) {
        FieldLocation start = new FieldLocation(index);
        FieldLocation end = new FieldLocation(index + 1);
        FieldRange range = new FieldRange(start, end);
        return this.intersect(range);
    }

    public FieldSelection intersect(BigInteger index) {
        FieldLocation start = new FieldLocation(index);
        FieldLocation end = new FieldLocation(index.add(BigInteger.ONE));
        FieldRange range = new FieldRange(start, end);
        return this.intersect(range);
    }

    public FieldSelection intersect(FieldRange range) {
        FieldSelection intersection = new FieldSelection();
        int insertIndex = Collections.binarySearch(this.ranges, range);
        if (insertIndex >= 0) {
            intersection.addRange(range);
            return intersection;
        }
        if ((insertIndex = -insertIndex - 2) < 0) {
            ++insertIndex;
        }
        while (insertIndex < this.ranges.size()) {
            FieldRange searchRange = this.ranges.get(insertIndex);
            if (searchRange.start.compareTo(range.end) >= 0) break;
            FieldRange newRange = searchRange.intersect(range);
            if (newRange != null) {
                intersection.addRange(newRange);
            }
            ++insertIndex;
        }
        return intersection;
    }

    public void addRange(FieldRange range) {
        this.addRange(range.start, range.end);
    }

    @Override
    public Iterator<FieldRange> iterator() {
        return this.ranges.iterator();
    }
}

