/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.util.GraphicsUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public class AttributedString {
    private static final int UNDERLINE_HEIGHT = 1;
    private boolean isUnderlined;
    private Color underlineColor;
    private String text;
    private Icon icon;
    private FontMetrics fontMetrics;
    private Color textColor;
    int textWidth = -1;

    AttributedString() {
    }

    public AttributedString(String text, Color textColor, FontMetrics fontMetrics) {
        this(text, textColor, fontMetrics, false, null);
    }

    public AttributedString(String text, Color textColor, FontMetrics fontMetrics, boolean underline, Color underlineColor) {
        this(null, text, textColor, fontMetrics, underline, underlineColor);
    }

    public AttributedString(Icon icon, String text, Color textColor, FontMetrics fontMetrics, boolean underline, Color underlineColor) {
        if (underline && underlineColor == null) {
            throw new NullPointerException("underline color cannot be null when underlining.");
        }
        this.icon = icon;
        this.text = text;
        this.fontMetrics = fontMetrics;
        this.textColor = textColor;
        this.isUnderlined = underline;
        this.underlineColor = underlineColor;
    }

    public String getText() {
        return this.text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int length() {
        return this.getText().length();
    }

    private int getIconWidth() {
        return this.icon == null ? 0 : this.icon.getIconWidth();
    }

    public int getStringWidth() {
        if (this.textWidth == -1) {
            this.textWidth = this.getIconWidth() + this.fontMetrics.stringWidth(this.text);
        }
        return this.textWidth;
    }

    public int getHeightAbove() {
        return this.fontMetrics.getMaxAscent() + this.fontMetrics.getLeading();
    }

    public int getHeightBelow() {
        return this.fontMetrics.getMaxDescent() + 1;
    }

    public int getColumnPosition(int width) {
        int subWidth = this.getIconWidth();
        for (int i = 0; i < this.text.length(); ++i) {
            if ((subWidth += this.fontMetrics.charWidth(this.text.charAt(i))) <= width) continue;
            return i;
        }
        return this.text.length();
    }

    public FontMetrics getFontMetrics(int charIndex) {
        return this.fontMetrics;
    }

    public Color getColor(int charIndex) {
        return this.textColor;
    }

    public AttributedString substring(int start) {
        AttributedString newString = this.deriveAttributedString(this.text.substring(start));
        if (start == 0) {
            newString.icon = this.icon;
        }
        return newString;
    }

    public AttributedString substring(int start, int end) {
        if (start == 0 && end == this.text.length()) {
            return this;
        }
        AttributedString newString = this.deriveAttributedString(this.text.substring(start, end));
        if (start == 0) {
            newString.icon = this.icon;
        }
        return newString;
    }

    public AttributedString replaceAll(char[] targets, char repacement) {
        StringBuffer buffer = new StringBuffer();
        int n = this.text.length();
        for (int i = 0; i < n; ++i) {
            char c = this.text.charAt(i);
            if (this.contains(targets, c)) {
                buffer.append(repacement);
                continue;
            }
            buffer.append(c);
        }
        return this.deriveAttributedString(buffer.toString());
    }

    private boolean contains(char[] targets, char candidate) {
        for (char target : targets) {
            if (target != candidate) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getText();
    }

    public void paint(JComponent c, Graphics g, int x, int y) {
        if (this.icon != null) {
            this.icon.paintIcon(null, g, x, -this.fontMetrics.getHeight());
            x += this.icon.getIconWidth();
        }
        g.setFont(this.fontMetrics.getFont());
        if (this.isUnderlined) {
            g.setColor(this.underlineColor);
            int descent = this.fontMetrics.getDescent();
            g.fillRect(x, descent - 1, this.getStringWidth(), 1);
        }
        g.setColor(this.textColor);
        GraphicsUtils.drawString(c, g, this.text, x, 0);
    }

    public AttributedString deriveAttributedString(String newText) {
        AttributedString newString = new AttributedString();
        newString.text = newText;
        newString.fontMetrics = this.fontMetrics;
        newString.textColor = this.textColor;
        newString.isUnderlined = this.isUnderlined;
        newString.underlineColor = this.underlineColor;
        return newString;
    }
}

