/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.OptionsEditorPanel;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.MiddleLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;

public class ScrollableOptionsEditor
extends JScrollPane
implements OptionsEditor {
    private OptionsEditorPanel optionsPanel;

    public ScrollableOptionsEditor(String title, Options options, List<String> optionNames, EditorStateFactory editorStateFactory) {
        this.optionsPanel = new OptionsEditorPanel(title, options, optionNames, editorStateFactory);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        ScollableOptionsPanel outerPanel = new ScollableOptionsPanel();
        outerPanel.add(this.optionsPanel);
        this.setViewportView(outerPanel);
    }

    public void dispose() {
    }

    public void apply() throws InvalidInputException {
        this.optionsPanel.apply();
    }

    public void cancel() {
    }

    public void reload() {
    }

    public JComponent getEditorComponent(Options options, EditorStateFactory factory) {
        return this;
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.optionsPanel.setOptionsPropertyChangeListener(listener);
    }

    private class ScollableOptionsPanel
    extends JPanel
    implements Scrollable {
        ScollableOptionsPanel() {
            super((LayoutManager)new MiddleLayout());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Dimension mySize = this.getPreferredSize();
            Dimension viewSize = ScrollableOptionsEditor.this.getViewport().getSize();
            boolean viewIsLarger = viewSize.height > mySize.height;
            return viewIsLarger;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Dimension mySize = this.getPreferredSize();
            Dimension viewSize = ScrollableOptionsEditor.this.getViewport().getSize();
            boolean viewIsLarger = viewSize.width > mySize.width;
            return viewIsLarger;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }
}

