/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.actions.KeyBindingUtils;
import docking.widgets.CursorPosition;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import generic.util.WindowUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpSearchNavigator;
import javax.help.SearchHit;
import javax.help.TextHelpModel;
import javax.help.search.SearchEngine;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

class HelpViewSearcher {
    private static final String DIALOG_TITLE_PREFIX = "Whole Word Search in ";
    private static final String FIND_ACTION_NAME = "find.action";
    private static KeyStroke FIND_KEYSTROKE = KeyStroke.getKeyStroke(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private Comparator<SearchHit> searchResultComparator = (o1, o2) -> o1.getBegin() - o2.getBegin();
    private Comparator<? super SearchHit> searchResultReverseComparator = (o1, o2) -> o2.getBegin() - o1.getBegin();
    private JHelp jHelp;
    private SearchEngine searchEngine;
    private HelpModel helpModel;
    private JEditorPane htmlEditorPane;
    private FindDialog findDialog;
    private boolean startSearchFromBeginning;
    private boolean settingHighlights;

    HelpViewSearcher(JHelp jHelp, HelpModel helpModel) {
        this.jHelp = jHelp;
        this.helpModel = helpModel;
        this.findDialog = new FindDialog(DIALOG_TITLE_PREFIX, new Searcher()){

            @Override
            public void close() {
                super.close();
                HelpViewSearcher.this.clearHighlights();
            }
        };
        this.grabSearchEngine();
        JHelpContentViewer contentViewer = jHelp.getContentViewer();
        contentViewer.addTextHelpModelListener(e -> {
            if (this.settingHighlights) {
                return;
            }
            this.clearSearchState();
        });
        contentViewer.addHelpModelListener(e -> {
            URL url = e.getURL();
            if (!this.isValidHelpURL(url)) {
                return;
            }
            String file = url.getFile();
            int separatorIndex = file.lastIndexOf(File.separator);
            file = file.substring(separatorIndex + 1);
            this.findDialog.setTitle(DIALOG_TITLE_PREFIX + file);
            this.clearSearchState();
        });
        this.htmlEditorPane = this.getHTMLEditorPane(contentViewer);
        this.htmlEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HelpViewSearcher.this.htmlEditorPane.getCaret().setVisible(true);
                HelpViewSearcher.this.startSearchFromBeginning = false;
            }
        });
        this.installPopup();
        this.installKeybindings();
    }

    private boolean isValidHelpURL(URL url) {
        if (url == null) {
            return false;
        }
        String file = url.getFile();
        return new File(file).exists();
    }

    private void grabSearchEngine() {
        Enumeration navigators = this.jHelp.getHelpNavigators();
        while (navigators.hasMoreElements()) {
            Object element = navigators.nextElement();
            if (!(element instanceof JHelpSearchNavigator)) continue;
            this.searchEngine = ((JHelpSearchNavigator)element).getSearchEngine();
        }
        if (this.searchEngine == null) {
            throw new AssertException("Unable to locate help search engine");
        }
    }

    private void installPopup() {
        this.htmlEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HelpViewSearcher.this.showPopupMenu(e);
                    return;
                }
            }
        });
    }

    private void installKeybindings() {
        KeyBindingUtils.registerAction((JComponent)this.htmlEditorPane, FIND_KEYSTROKE, new FindDialogAction(), 1);
    }

    private void showPopupMenu(MouseEvent e) {
        JMenuItem menuItem = new JMenuItem("Find on Page...");
        menuItem.setAction(new FindDialogAction());
        menuItem.setText("Find on Page...");
        JPopupMenu menu = new JPopupMenu();
        menu.add(menuItem);
        menu.show(this.htmlEditorPane, e.getX(), e.getY());
    }

    private JEditorPane getHTMLEditorPane(JHelpContentViewer contentViewer) {
        Component[] components = contentViewer.getComponents();
        JScrollPane scrollPane = (JScrollPane)components[0];
        JViewport viewport = scrollPane.getViewport();
        return (JEditorPane)viewport.getView();
    }

    private void clearSearchState() {
        this.startSearchFromBeginning = true;
    }

    private void clearHighlights() {
        ((TextHelpModel)this.helpModel).setHighlights((TextHelpModel.Highlight[])new DefaultHelpModel.DefaultHighlight[0]);
    }

    private class ScreenSearchTask
    extends Task {
        private String text;
        private List<SearchHit> searchHits;
        private boolean useRegex;

        ScreenSearchTask(String text, boolean useRegex) {
            super("Help Search Task", true, false, true, true);
            this.searchHits = new ArrayList<SearchHit>();
            this.text = text;
            this.useRegex = useRegex;
        }

        public void run(TaskMonitor monitor) {
            Document document = HelpViewSearcher.this.htmlEditorPane.getDocument();
            try {
                String screenText = document.getText(0, document.getLength());
                if (this.useRegex) {
                    Pattern pattern = Pattern.compile(this.text, 34);
                    Matcher matcher = pattern.matcher(screenText);
                    while (matcher.find()) {
                        int start = matcher.start();
                        int end = matcher.end();
                        this.searchHits.add(new SearchHit(1.0, start, end));
                    }
                } else {
                    int start = 0;
                    for (int wordOffset = this.text.length(); wordOffset < document.getLength(); ++wordOffset) {
                        String searchFor = screenText.substring(start, wordOffset);
                        if (this.text.compareToIgnoreCase(searchFor) == 0) {
                            this.searchHits.add(new SearchHit(1.0, start, wordOffset));
                        }
                        ++start;
                    }
                }
            }
            catch (BadLocationException e) {
                Msg.debug((Object)((Object)this), (Object)"Unexpected exception retrieving help text", (Throwable)e);
            }
            catch (PatternSyntaxException e) {
                Msg.showError((Object)((Object)this), (Component)HelpViewSearcher.this.htmlEditorPane, (String)"Regular Expression Syntax Error", (Object)e.getMessage());
            }
        }

        List<SearchHit> getSearchResults() {
            return this.searchHits;
        }
    }

    private class Searcher
    implements FindDialogSearcher {
        private Searcher() {
        }

        @Override
        public CursorPosition getCursorPosition() {
            if (HelpViewSearcher.this.startSearchFromBeginning) {
                HelpViewSearcher.this.startSearchFromBeginning = false;
                return new CursorPosition(0);
            }
            int caretPosition = HelpViewSearcher.this.htmlEditorPane.getCaretPosition();
            return new CursorPosition(caretPosition);
        }

        @Override
        public CursorPosition getStart() {
            return new CursorPosition(0);
        }

        @Override
        public CursorPosition getEnd() {
            int length = HelpViewSearcher.this.htmlEditorPane.getDocument().getLength();
            return new CursorPosition(length - 1);
        }

        @Override
        public void setCursorPosition(CursorPosition position) {
            int cursorPosition = position.getPosition();
            HelpViewSearcher.this.htmlEditorPane.setCaretPosition(cursorPosition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void highlightSearchResults(SearchLocation location) {
            if (location == null) {
                ((TextHelpModel)HelpViewSearcher.this.helpModel).setHighlights((TextHelpModel.Highlight[])new DefaultHelpModel.DefaultHighlight[0]);
                return;
            }
            int start = location.getStartIndexInclusive();
            DefaultHelpModel.DefaultHighlight[] h = new DefaultHelpModel.DefaultHighlight[]{new DefaultHelpModel.DefaultHighlight(start, location.getEndIndexInclusive())};
            try {
                HelpViewSearcher.this.settingHighlights = true;
                ((TextHelpModel)HelpViewSearcher.this.helpModel).setHighlights((TextHelpModel.Highlight[])h);
                HelpViewSearcher.this.htmlEditorPane.getCaret().setVisible(true);
            }
            finally {
                HelpViewSearcher.this.settingHighlights = false;
            }
            try {
                Rectangle rectangle = HelpViewSearcher.this.htmlEditorPane.modelToView(start);
                HelpViewSearcher.this.htmlEditorPane.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public SearchLocation search(String text, CursorPosition cursorPosition, boolean searchForward, boolean useRegex) {
            ScreenSearchTask searchTask = new ScreenSearchTask(text, useRegex);
            new TaskLauncher(searchTask, HelpViewSearcher.this.htmlEditorPane);
            List<SearchHit> searchResults = searchTask.getSearchResults();
            int position = cursorPosition.getPosition();
            if (searchForward) {
                Collections.sort(searchResults, HelpViewSearcher.this.searchResultComparator);
                for (SearchHit searchHit : searchResults) {
                    int begin = searchHit.getBegin();
                    if (begin <= position) continue;
                    return new SearchLocation(begin, searchHit.getEnd(), text, searchForward);
                }
            } else {
                Collections.sort(searchResults, HelpViewSearcher.this.searchResultReverseComparator);
                for (SearchHit searchHit : searchResults) {
                    int begin = searchHit.getBegin();
                    if (begin >= position) continue;
                    return new SearchLocation(begin, searchHit.getEnd(), text, searchForward);
                }
            }
            return null;
        }
    }

    private class FindDialogAction
    extends AbstractAction {
        FindDialogAction() {
            super(HelpViewSearcher.FIND_ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window helpWindow = WindowUtilities.windowForComponent((Component)HelpViewSearcher.this.htmlEditorPane);
            DockingWindowManager.showDialog(helpWindow, HelpViewSearcher.this.findDialog);
        }
    }
}

