/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.ErrLogDialog;
import docking.ErrLogExpandableDialog;
import docking.widgets.OkDialog;
import ghidra.util.ConsoleErrorDisplay;
import ghidra.util.ErrorDisplay;
import ghidra.util.ErrorLogger;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.MultipleCauses;
import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class DockingErrorDisplay
implements ErrorDisplay {
    private static final int TRACE_BUFFER_SIZE = 250;
    ConsoleErrorDisplay consoleDisplay = new ConsoleErrorDisplay();

    public void displayInfoMessage(ErrorLogger errorLogger, Object originator, Component parent, String title, Object message) {
        this.displayMessage(MessageType.INFO, errorLogger, originator, parent, title, message, null);
    }

    public void displayErrorMessage(ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        this.displayMessage(MessageType.ERROR, errorLogger, originator, parent, title, message, throwable);
    }

    public void displayWarningMessage(ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        this.displayMessage(MessageType.WARNING, errorLogger, originator, parent, title, message, throwable);
    }

    private void displayMessage(MessageType messageType, ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        int dialogType = -1;
        String messageString = message != null ? message.toString() : null;
        String rawMessage = HTMLUtilities.fromHTML((String)messageString);
        switch (messageType) {
            case INFO: {
                dialogType = 1;
                this.consoleDisplay.displayInfoMessage(errorLogger, originator, parent, title, (Object)rawMessage);
                break;
            }
            case WARNING: 
            case ALERT: {
                dialogType = 2;
                this.consoleDisplay.displayWarningMessage(errorLogger, originator, parent, title, (Object)rawMessage, throwable);
                break;
            }
            case ERROR: {
                this.consoleDisplay.displayErrorMessage(errorLogger, originator, parent, title, (Object)rawMessage, throwable);
                dialogType = 0;
            }
        }
        this.showDialog(title, message, throwable, dialogType, messageString, this.getWindow(parent));
    }

    private Component getWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return component;
    }

    private void showDialog(String title, Object message, Throwable throwable, int dialogType, String messageString, Component parent) {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> this.doShowDialog(title, message, throwable, dialogType, messageString, parent));
    }

    private void doShowDialog(String title, Object message, Throwable throwable, int dialogType, String messageString, Component parent) {
        DialogComponentProvider dialog = null;
        dialog = throwable != null ? this.createErrorDialog(title, message, throwable, messageString) : new OkDialog(title, messageString, dialogType);
        DockingWindowManager.showDialog(parent, dialog);
    }

    private DialogComponentProvider createErrorDialog(String title, Object message, Throwable throwable, String messageString) {
        if (this.containsMultipleCauses(throwable)) {
            return new ErrLogExpandableDialog(title, messageString, throwable);
        }
        return ErrLogDialog.createExceptionDialog(title, messageString, this.buildStackTrace(throwable, message == null ? throwable.getMessage() : messageString));
    }

    private boolean containsMultipleCauses(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof MultipleCauses) {
            return true;
        }
        return this.containsMultipleCauses(throwable.getCause());
    }

    private String buildStackTrace(Throwable t, String msg) {
        StringBuffer sb = new StringBuffer(250);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        if (msg != null) {
            ps.println(msg);
        }
        t.printStackTrace(ps);
        sb.append(baos.toString());
        ps.close();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

