/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.ProcessorSymbolType;

public class AddressLabelInfo
implements Comparable<AddressLabelInfo> {
    private Address addr;
    private String label;
    private boolean isPrimary;
    private Namespace scope;
    private SourceType symbolSource;
    private boolean isEntry;
    private ProcessorSymbolType processorSymbolType;

    public AddressLabelInfo(Symbol s) {
        this.addr = s.getAddress();
        this.label = s.getName();
        this.isPrimary = s.isPrimary();
        this.scope = s.getParentNamespace();
        this.symbolSource = s.getSource();
        this.isEntry = s.isExternalEntryPoint();
    }

    public AddressLabelInfo(Address addr, String label, boolean isPrimary, Namespace scope, SourceType symbolSource, boolean isEntry) {
        this(addr, label, isPrimary, scope, symbolSource, isEntry, null);
    }

    public AddressLabelInfo(Address addr, String label, boolean isPrimary, Namespace scope, SourceType symbolSource, boolean isEntry, ProcessorSymbolType type) {
        this.addr = addr;
        this.label = label;
        this.isPrimary = isPrimary;
        this.scope = scope;
        this.symbolSource = symbolSource;
        this.isEntry = isEntry;
        this.processorSymbolType = type;
    }

    public AddressLabelInfo(Address addr, String label, boolean isPrimary, SourceType symbolSource) {
        this(addr, label, isPrimary, null, symbolSource, false);
    }

    public AddressLabelInfo(Address addr) {
        this(addr, null, false, null, SourceType.DEFAULT, false);
    }

    public final Address getAddress() {
        return this.addr;
    }

    public final String getLabel() {
        return this.label;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public Namespace getScope() {
        return this.scope;
    }

    public ProcessorSymbolType getProcessorSymbolType() {
        return this.processorSymbolType;
    }

    @Override
    public int compareTo(AddressLabelInfo info) {
        if (info == null) {
            return 1;
        }
        String addrStr = info.getAddress().toString();
        String thisStr = this.getAddress().toString();
        int stringCompare = thisStr.compareTo(addrStr);
        if (stringCompare != 0) {
            return stringCompare;
        }
        String addrLabel = info.getLabel();
        String thisLabel = this.getLabel();
        if (addrLabel == null) {
            if (thisLabel == null) {
                return 0;
            }
            return 1;
        }
        if (thisLabel == null) {
            return -1;
        }
        return thisLabel.compareTo(addrLabel);
    }

    public SourceType getSource() {
        return this.symbolSource;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LABEL INFO NAME=");
        buf.append(this.label);
        buf.append(", ");
        buf.append("ADDR=" + this.addr);
        buf.append(", ");
        buf.append("isEntry = " + this.isEntry);
        buf.append(", ");
        buf.append("type = " + this.processorSymbolType);
        return buf.toString();
    }
}

