/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class SequenceNumber
implements Comparable<SequenceNumber> {
    private Address pc;
    private int uniq;
    private int order;

    public SequenceNumber(Address instrAddr, int sequenceNum) {
        this.pc = instrAddr;
        this.uniq = sequenceNum;
    }

    public Address getTarget() {
        return this.pc;
    }

    public int getTime() {
        return this.uniq;
    }

    public void setTime(int t) {
        this.uniq = t;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int o) {
        this.order = o;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SequenceNumber)) {
            return false;
        }
        SequenceNumber sq = (SequenceNumber)o;
        return this.pc.equals(sq.pc) && this.uniq == sq.uniq;
    }

    @Override
    public int compareTo(SequenceNumber sq) {
        int val = this.pc.compareTo(sq.pc);
        if (val != 0) {
            return val;
        }
        if (this.uniq < sq.uniq) {
            return -1;
        }
        if (sq.uniq < this.uniq) {
            return 1;
        }
        return 0;
    }

    public StringBuilder buildXML() {
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<seqnum");
        AddressSpace space = this.pc.getAddressSpace();
        SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"space", (String)space.getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"offset", (long)this.pc.getOffset());
        if (this.uniq != -1) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"uniq", (long)this.uniq);
        }
        resBuf.append("/>");
        return resBuf;
    }

    public static SequenceNumber readXML(XmlPullParser parser, AddressFactory factory) {
        XmlElement el = parser.start(new String[]{"seqnum"});
        String attrstring = el.getAttribute("uniq");
        int uniq = attrstring != null ? SpecXmlUtils.decodeInt((String)attrstring) : -1;
        String space = el.getAttribute("space");
        AddressSpace spc = factory.getAddressSpace(space);
        long offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
        parser.end(el);
        return new SequenceNumber(spc.getAddress(offset), uniq);
    }

    public String toString() {
        return "(" + this.pc.getAddressSpace().getName() + ", 0x" + Long.toHexString(this.pc.getOffset()) + ", " + this.uniq + ", " + this.order + ")";
    }

    public int hashCode() {
        return this.pc.hashCode() + this.uniq;
    }
}

