/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.PcodeEmitObjects;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class InjectPayloadSleigh
implements InjectPayload {
    private ConstructTpl pcodeTemplate;
    private int paramShift;
    private boolean isfallthru;
    private InjectPayload.InjectParameter[] inputlist;
    private InjectPayload.InjectParameter[] output;
    protected String name;
    protected int type;
    protected String source;
    private String parseString;

    protected InjectPayloadSleigh(String sourceName) {
        this.name = null;
        this.type = -1;
        this.inputlist = null;
        this.output = null;
        this.source = sourceName;
    }

    public InjectPayloadSleigh clone() {
        InjectPayloadSleigh res = new InjectPayloadSleigh(this.source);
        res.copy(this);
        return res;
    }

    protected void copy(InjectPayloadSleigh op2) {
        int i;
        this.inputlist = null;
        this.output = null;
        this.paramShift = op2.paramShift;
        this.isfallthru = op2.isfallthru;
        this.name = op2.name;
        this.type = op2.type;
        this.source = op2.source;
        this.parseString = op2.parseString;
        if (op2.inputlist != null) {
            this.inputlist = new InjectPayload.InjectParameter[op2.inputlist.length];
            for (i = 0; i < this.inputlist.length; ++i) {
                this.inputlist[i] = new InjectPayload.InjectParameter(op2.inputlist[i].getName(), op2.inputlist[i].getSize());
                this.inputlist[i].setIndex(op2.inputlist[i].getIndex());
            }
        }
        if (op2.output != null) {
            this.output = new InjectPayload.InjectParameter[op2.output.length];
            for (i = 0; i < this.output.length; ++i) {
                this.output[i] = new InjectPayload.InjectParameter(op2.output[i].getName(), op2.output[i].getSize());
                this.output[i].setIndex(op2.output[i].getIndex());
            }
        }
    }

    public InjectPayloadSleigh(String nm, int tp, String sourceName) {
        this.name = nm;
        this.type = tp;
        this.inputlist = null;
        this.output = null;
        this.source = sourceName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getParamShift() {
        return this.paramShift;
    }

    protected void setInputParameters(ArrayList<InjectPayload.InjectParameter> in) {
        this.inputlist = new InjectPayload.InjectParameter[in.size()];
        in.toArray(this.inputlist);
    }

    protected void setOutputParameters(ArrayList<InjectPayload.InjectParameter> out) {
        this.output = new InjectPayload.InjectParameter[out.size()];
        out.toArray(this.output);
    }

    @Override
    public InjectPayload.InjectParameter[] getInput() {
        return this.inputlist;
    }

    @Override
    public InjectPayload.InjectParameter[] getOutput() {
        return this.output;
    }

    @Override
    public void inject(InjectContext context, PcodeEmit emit) {
        ParserWalker walker = emit.getWalker();
        try {
            walker.snippetState();
            this.setupParameters(context, walker);
            emit.build(this.pcodeTemplate, -1);
        }
        catch (UnknownInstructionException e) {
            e.printStackTrace();
            return;
        }
        catch (MemoryAccessException e) {
            e.printStackTrace();
            return;
        }
        emit.resolveRelatives();
    }

    @Override
    public PcodeOp[] getPcode(Program program, InjectContext con) {
        SleighParserContext protoContext = new SleighParserContext(con.baseAddr, con.nextAddr, con.refAddr, con.callAddr);
        ParserWalker walker = new ParserWalker(protoContext);
        PcodeEmitObjects emit = new PcodeEmitObjects(walker);
        this.inject(con, emit);
        return emit.getPcodeOp();
    }

    @Override
    public boolean isFallThru() {
        return this.isfallthru;
    }

    private boolean computeFallThru() {
        OpTpl[] opVec = this.pcodeTemplate.getOpVec();
        if (opVec.length <= 0) {
            return true;
        }
        switch (opVec[opVec.length - 1].getOpcode()) {
            case 4: 
            case 6: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    protected void orderParameters() {
        int id = 0;
        for (InjectPayload.InjectParameter element : this.inputlist) {
            element.setIndex(id);
            ++id;
        }
        for (InjectPayload.InjectParameter element : this.output) {
            element.setIndex(id);
            ++id;
        }
    }

    public void restoreXml(XmlPullParser parser) {
        ArrayList<InjectPayload.InjectParameter> inlist = new ArrayList<InjectPayload.InjectParameter>();
        ArrayList<InjectPayload.InjectParameter> outlist = new ArrayList<InjectPayload.InjectParameter>();
        XmlElement el = parser.start(new String[0]);
        String pshiftstr = el.getAttribute("paramshift");
        this.paramShift = SpecXmlUtils.decodeInt((String)pshiftstr);
        boolean isDynamic = false;
        String dynstr = el.getAttribute("dynamic");
        if (dynstr != null) {
            isDynamic = SpecXmlUtils.decodeBoolean((String)dynstr);
        }
        XmlElement subel = parser.peek();
        while (subel.isStart()) {
            subel = parser.start(new String[0]);
            if (subel.getName().equals("body")) {
                this.parseString = parser.end(subel).getText();
                break;
            }
            String paramName = subel.getAttribute("name");
            int size = SpecXmlUtils.decodeInt((String)subel.getAttribute("size"));
            InjectPayload.InjectParameter param = new InjectPayload.InjectParameter(paramName, size);
            if (subel.getName().equals("input")) {
                inlist.add(param);
            } else {
                outlist.add(param);
            }
            parser.end(subel);
            subel = parser.peek();
        }
        parser.end(el);
        if (this.parseString != null) {
            this.parseString = this.parseString.trim();
            if (this.parseString.length() == 0) {
                this.parseString = null;
            }
        }
        if (this.parseString == null && !isDynamic) {
            throw new SleighException("Missing pcode <body> in injection: " + this.source);
        }
        this.setInputParameters(inlist);
        this.setOutputParameters(outlist);
        this.orderParameters();
    }

    String releaseParseString() {
        String res = this.parseString;
        this.parseString = null;
        return res;
    }

    public void setTemplate(ConstructTpl ctl) {
        this.pcodeTemplate = ctl;
        this.isfallthru = this.computeFallThru();
    }

    private void checkParameterRestrictions(InjectContext con, Address addr) {
        int outsize;
        int insize;
        int n = insize = con.inputlist == null ? 0 : con.inputlist.size();
        if (this.inputlist.length != insize) {
            throw new SleighException("Input parameters do not match injection specification: " + this.source);
        }
        for (int i = 0; i < this.inputlist.length; ++i) {
            int sz = this.inputlist[i].getSize();
            if (sz == 0 || sz == con.inputlist.get(i).getSize()) continue;
            throw new SleighException("Input parameter size does not match injection specification: " + this.source);
        }
        int n2 = outsize = con.output == null ? 0 : con.output.size();
        if (this.output.length != outsize) {
            throw new SleighException("Output does not match injection specification: " + this.source);
        }
        for (int i = 0; i < this.output.length; ++i) {
            int sz = this.output[i].getSize();
            if (sz == 0 || sz == con.output.get(i).getSize()) continue;
            throw new SleighException("Output size does not match injection specification: " + this.source);
        }
    }

    private void setupParameters(InjectContext con, ParserWalker walker) throws UnknownInstructionException {
        FixedHandle hand;
        Varnode vn;
        int i;
        this.checkParameterRestrictions(con, walker.getAddr());
        for (i = 0; i < this.inputlist.length; ++i) {
            walker.allocateOperand();
            vn = con.inputlist.get(i);
            hand = walker.getParentHandle();
            hand.space = vn.getAddress().getAddressSpace();
            hand.offset_offset = vn.getOffset();
            hand.size = vn.getSize();
            hand.offset_space = null;
            walker.popOperand();
        }
        for (i = 0; i < this.output.length; ++i) {
            walker.allocateOperand();
            vn = con.output.get(i);
            hand = walker.getParentHandle();
            hand.space = vn.getAddress().getAddressSpace();
            hand.offset_offset = vn.getOffset();
            hand.size = vn.getSize();
            hand.offset_space = null;
            walker.popOperand();
        }
    }
}

